/*
 * Decompiled with CFR 0.152.
 */
package shz.queue;

import shz.queue.ArrayQueue;

public class LArrayQueue<E>
extends ArrayQueue<E> {
    protected E[] es;

    protected LArrayQueue(int capacity) {
        super(capacity);
        this.es = new Object[capacity];
    }

    public static <E> LArrayQueue<E> of(int capacity) {
        return new LArrayQueue<E>(capacity);
    }

    public static <E> LArrayQueue<E> of() {
        return LArrayQueue.of(8);
    }

    @Override
    protected final E get(int i) {
        return this.es[i];
    }

    @Override
    protected final void resize(int capacity) {
        this.capacity = capacity;
        Object[] temp = new Object[capacity];
        for (int i = 0; i < this.size; ++i) {
            temp[i] = this.es[(i + this.head) % capacity];
        }
        this.head = 0;
        this.tail = this.size;
        this.es = temp;
    }

    @Override
    protected final void setNull(int i) {
        this.es[i] = null;
    }

    public final void offer(E e) {
        this.beforeOffer();
        this.es[this.tail] = e;
        this.afterOffer();
    }

    public final E poll() {
        E e = this.es[this.head];
        this.afterPoll();
        return e;
    }

    public final E head() {
        return this.es[this.head];
    }

    public final E tail() {
        return this.es[this.tail == 0 ? this.capacity - 1 : this.tail - 1];
    }
}

