/*
 * Decompiled with CFR 0.152.
 */
package shz.queue;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import shz.Validator;

public class PQueue<E> {
    protected E[] queue;
    protected int size;
    protected final Comparator<? super E> comparator;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    protected PQueue(int capacity, Comparator<? super E> comparator) {
        Validator.requireNon(capacity < 1);
        Objects.requireNonNull(comparator);
        this.queue = new Object[capacity];
        this.comparator = comparator;
    }

    public static <E> PQueue<E> of(int capacity, Comparator<? super E> comparator) {
        return new PQueue<E>(capacity, comparator);
    }

    public static <E> PQueue<E> of(Comparator<? super E> comparator) {
        return PQueue.of(16, comparator);
    }

    public final int size() {
        return this.size;
    }

    public final boolean isEmpty() {
        return this.size == 0;
    }

    public final void offer(E e) {
        int i = this.size;
        if (i >= this.queue.length) {
            this.grow(i + 1);
        }
        this.size = i + 1;
        if (i == 0) {
            this.queue[0] = e;
        } else {
            this.siftUp(i, e);
        }
    }

    private void grow(int minCapacity) {
        int oldCapacity;
        int newCapacity = oldCapacity + ((oldCapacity = this.queue.length) < 64 ? oldCapacity + 2 : oldCapacity >> 1);
        if (newCapacity - 0x7FFFFFF7 > 0) {
            newCapacity = PQueue.hugeCapacity(minCapacity);
        }
        this.queue = Arrays.copyOf(this.queue, newCapacity);
    }

    private static int hugeCapacity(int minCapacity) {
        if (minCapacity < 0) {
            throw new OutOfMemoryError();
        }
        return minCapacity > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
    }

    private void siftUp(int k, E x) {
        int parent;
        E e;
        while (k > 0 && this.comparator.compare(x, e = this.queue[parent = k - 1 >>> 1]) <= 0) {
            this.queue[k] = e;
            k = parent;
        }
        this.queue[k] = x;
    }

    public final E poll() {
        if (this.size == 0) {
            return null;
        }
        int s = --this.size;
        E result = this.queue[0];
        E x = this.queue[s];
        this.queue[s] = null;
        if (s != 0) {
            this.siftDown(0, x);
        }
        return result;
    }

    private void siftDown(int k, E x) {
        int half = this.size >>> 1;
        while (k < half) {
            int child = (k << 1) + 1;
            E c = this.queue[child];
            int right = child + 1;
            if (right < this.size && this.comparator.compare(c, this.queue[right]) > 0) {
                child = right;
                c = this.queue[child];
            }
            if (this.comparator.compare(x, c) < 0) break;
            this.queue[k] = c;
            k = child;
        }
        this.queue[k] = x;
    }

    public final E peek() {
        return this.size == 0 ? null : (E)this.queue[0];
    }
}

