/*
 * Decompiled with CFR 0.152.
 */
package shz.queue;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import shz.stack.LArrayStack;

public abstract class RedBlackBSTPQueue<E> {
    Node<E> root;
    final Comparator<? super E> comparator;

    RedBlackBSTPQueue(Comparator<? super E> comparator) {
        Objects.requireNonNull(comparator);
        this.comparator = comparator;
    }

    public final int size() {
        return this.size(this.root);
    }

    private int size(Node<E> h) {
        return h == null ? 0 : h.size;
    }

    public final boolean isEmpty() {
        return this.root == null || this.root.size == 0;
    }

    final Node<E> put(Node<E> h, E e) {
        if (h == null) {
            return new Node<E>(e, true);
        }
        int cmp = this.comparator.compare(e, h.e);
        if (cmp <= 0) {
            h.left = this.put(h.left, e);
        } else {
            h.right = this.put(h.right, e);
        }
        if (this.isRed(h.right) && !this.isRed(h.left)) {
            h = this.rotateLeft(h);
        }
        if (this.isRed(h.left) && this.isRed(h.left.left)) {
            h = this.rotateRight(h);
        }
        if (this.isRed(h.left) && this.isRed(h.right)) {
            this.flipColors(h);
        }
        h.size = this.size(h.left) + this.size(h.right) + 1;
        return h;
    }

    final boolean isRed(Node<E> h) {
        return h != null && h.red;
    }

    final Node<E> rotateLeft(Node<E> h) {
        Node x = h.right;
        h.right = x.left;
        x.left = h;
        x.red = h.red;
        h.red = true;
        x.size = h.size;
        h.size = 1 + this.size(h.left) + this.size(h.right);
        return x;
    }

    final Node<E> rotateRight(Node<E> h) {
        Node x = h.left;
        h.left = x.right;
        x.right = h;
        x.red = h.red;
        h.red = true;
        x.size = h.size;
        h.size = 1 + this.size(h.left) + this.size(h.right);
        return x;
    }

    final void flipColors(Node<E> h) {
        h.red = true;
        if (h.left != null) {
            h.left.red = false;
        }
        if (h.right != null) {
            h.right.red = false;
        }
    }

    final Node<E> balance(Node<E> h) {
        if (this.isRed(h.right)) {
            h = this.rotateLeft(h);
        }
        if (this.isRed(h.right) && !this.isRed(h.left)) {
            h = this.rotateLeft(h);
        }
        if (this.isRed(h.left) && this.isRed(h.left.left)) {
            h = this.rotateRight(h);
        }
        if (this.isRed(h.left) && this.isRed(h.right)) {
            this.flipColors(h);
        }
        h.size = this.size(h.left) + this.size(h.right) + 1;
        return h;
    }

    public abstract void offer(E var1);

    public abstract E poll();

    public abstract E peek();

    public final List<E> reverse() {
        int size = this.size();
        if (size == 0) {
            return Collections.emptyList();
        }
        LArrayStack<E> stack = LArrayStack.of(size);
        for (int i = 0; i < size; ++i) {
            stack.push(this.poll());
        }
        ArrayList result = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            result.add(stack.pop());
        }
        return result;
    }

    public static final class Max<E>
    extends RedBlackBSTPQueue<E> {
        private Max(Comparator<? super E> comparator) {
            super(comparator);
        }

        public static <E> Max<E> of(Comparator<? super E> comparator) {
            return new Max<E>(comparator);
        }

        @Override
        public void offer(E e) {
            Objects.requireNonNull(e);
            if (this.root == null) {
                this.root = new Node<E>(e, false);
                return;
            }
            this.root = this.put(this.root, e);
            this.root.red = false;
        }

        @Override
        public E poll() {
            E result = this.peek();
            if (result == null) {
                return null;
            }
            if (!this.isRed(this.root.left) && !this.isRed(this.root.right)) {
                this.root.red = true;
            }
            this.root = this.delTop(this.root);
            if (this.root != null && this.root.size > 0) {
                this.root.red = false;
            }
            return result;
        }

        @Override
        public E peek() {
            if (this.root == null) {
                return null;
            }
            Node h = this.root;
            while (h.right != null) {
                h = h.right;
            }
            return h.e;
        }

        private Node<E> delTop(Node<E> h) {
            if (this.isRed(h.left)) {
                h = this.rotateRight(h);
            }
            if (h.right == null) {
                return h.left;
            }
            if (!this.isRed(h.right) && !this.isRed(h.right.left)) {
                h = this.moveRedRight(h);
            }
            h.right = this.delTop(h.right);
            return this.balance(h);
        }

        private Node<E> moveRedRight(Node<E> h) {
            this.flipColors(h);
            if (h.left != null && !this.isRed(h.left.left)) {
                h = this.rotateRight(h);
            }
            return h;
        }
    }

    public static final class Min<E>
    extends RedBlackBSTPQueue<E> {
        private Min(Comparator<? super E> comparator) {
            super(comparator);
        }

        public static <E> Min<E> of(Comparator<? super E> comparator) {
            return new Min<E>(comparator);
        }

        @Override
        public void offer(E e) {
            Objects.requireNonNull(e);
            if (this.root == null) {
                this.root = new Node<E>(e, false);
                return;
            }
            this.root = this.put(this.root, e);
            this.root.red = false;
        }

        @Override
        public E poll() {
            E result = this.peek();
            if (result == null) {
                return null;
            }
            if (!this.isRed(this.root.left) && !this.isRed(this.root.right)) {
                this.root.red = true;
            }
            this.root = this.delTop(this.root);
            if (this.root != null && this.root.size > 0) {
                this.root.red = false;
            }
            return result;
        }

        @Override
        public E peek() {
            if (this.root == null) {
                return null;
            }
            Node h = this.root;
            while (h.left != null) {
                h = h.left;
            }
            return h.e;
        }

        private Node<E> delTop(Node<E> h) {
            if (h.left == null) {
                return h.right;
            }
            if (!this.isRed(h.left) && !this.isRed(h.left.left)) {
                h = this.moveRedLeft(h);
            }
            h.left = this.delTop(h.left);
            return this.balance(h);
        }

        private Node<E> moveRedLeft(Node<E> h) {
            this.flipColors(h);
            if (h.right != null && this.isRed(h.right.left)) {
                h.right = this.rotateRight(h.right);
                h = this.rotateLeft(h);
            }
            return h;
        }
    }

    static final class Node<E> {
        E e;
        Node<E> left;
        Node<E> right;
        int size = 1;
        boolean red;

        Node(E e, boolean red) {
            this.e = e;
            this.red = red;
        }
    }
}

