/*
 * Decompiled with CFR 0.152.
 */
package shz.queue;

import shz.queue.ArrayQueue;

public class SArrayQueue
extends ArrayQueue<Short> {
    protected short[] es;

    protected SArrayQueue(int capacity) {
        super(capacity);
        this.es = new short[capacity];
    }

    public static SArrayQueue of(int capacity) {
        return new SArrayQueue(capacity);
    }

    public static SArrayQueue of() {
        return SArrayQueue.of(8);
    }

    @Override
    protected final Short get(int i) {
        return this.es[i];
    }

    @Override
    protected final void resize(int capacity) {
        this.capacity = capacity;
        short[] temp = new short[capacity];
        for (int i = 0; i < this.size; ++i) {
            temp[i] = this.es[(i + this.head) % capacity];
        }
        this.head = 0;
        this.tail = this.size;
        this.es = temp;
    }

    @Override
    protected final void setNull(int i) {
        this.es[i] = 0;
    }

    public final void offer(short e) {
        this.beforeOffer();
        this.es[this.tail] = e;
        this.afterOffer();
    }

    public final short poll() {
        short e = this.es[this.head];
        this.afterPoll();
        return e;
    }

    public final short head() {
        return this.es[this.head];
    }

    public final short tail() {
        return this.es[this.tail == 0 ? this.capacity - 1 : this.tail - 1];
    }
}

