/*
 * Decompiled with CFR 0.152.
 */
package shz.queue;

import shz.queue.ArrayQueue;

public class ZArrayQueue
extends ArrayQueue<Boolean> {
    protected boolean[] es;

    protected ZArrayQueue(int capacity) {
        super(capacity);
        this.es = new boolean[capacity];
    }

    public static ZArrayQueue of(int capacity) {
        return new ZArrayQueue(capacity);
    }

    public static ZArrayQueue of() {
        return ZArrayQueue.of(8);
    }

    @Override
    protected final Boolean get(int i) {
        return this.es[i];
    }

    @Override
    protected final void resize(int capacity) {
        this.capacity = capacity;
        boolean[] temp = new boolean[capacity];
        for (int i = 0; i < this.size; ++i) {
            temp[i] = this.es[(i + this.head) % capacity];
        }
        this.head = 0;
        this.tail = this.size;
        this.es = temp;
    }

    @Override
    protected final void setNull(int i) {
        this.es[i] = false;
    }

    public final void offer(boolean e) {
        this.beforeOffer();
        this.es[this.tail] = e;
        this.afterOffer();
    }

    public final boolean poll() {
        boolean e = this.es[this.head];
        this.afterPoll();
        return e;
    }

    public final boolean head() {
        return this.es[this.head];
    }

    public final boolean tail() {
        return this.es[this.tail == 0 ? this.capacity - 1 : this.tail - 1];
    }
}

