/*
 * Decompiled with CFR 0.152.
 */
package shz.st.bst;

import shz.queue.LLinkedQueue;

public class BST<K extends Comparable<K>, V> {
    protected Node<K, V> root;

    protected BST(K key, V val) {
        this.root = new Node<K, V>(key, val);
    }

    public static <K extends Comparable<K>, V> BST<K, V> of(K key, V val) {
        if (key == null) {
            throw new NullPointerException();
        }
        return new BST<K, V>(key, val);
    }

    public static <K extends Comparable<K>, V> BST<K, V> of(K key) {
        return BST.of(key, null);
    }

    public final int size() {
        return this.size(this.root);
    }

    protected final int size(Node<K, V> x) {
        return x == null ? 0 : x.size;
    }

    public final int sizeLe(K hi) {
        if (hi == null) {
            throw new NullPointerException();
        }
        return this.sizeLe(this.root, hi);
    }

    protected final int sizeLe(Node<K, V> x, K hi) {
        int res = 0;
        while (x != null) {
            if (hi.compareTo(x.key) < 0) {
                x = x.left;
                continue;
            }
            res += 1 + this.size(x.left);
            x = x.right;
        }
        return res;
    }

    public final int sizeGe(K lo) {
        if (lo == null) {
            throw new NullPointerException();
        }
        return this.sizeGe(this.root, lo);
    }

    protected final int sizeGe(Node<K, V> x, K lo) {
        int res = 0;
        while (x != null) {
            if (lo.compareTo(x.key) > 0) {
                x = x.right;
                continue;
            }
            res += 1 + this.size(x.right);
            x = x.left;
        }
        return res;
    }

    public final int size(K lo, K hi) {
        if (lo == null || hi == null) {
            throw new NullPointerException();
        }
        if (lo.compareTo(hi) > 0) {
            throw new IllegalArgumentException();
        }
        return this.size(this.root, lo, hi);
    }

    protected final int size(Node<K, V> x, K lo, K hi) {
        int res = 0;
        while (x != null) {
            int cmp_lo = lo.compareTo(x.key);
            if (cmp_lo > 0) {
                x = x.right;
                continue;
            }
            if (cmp_lo == 0) {
                res += 1 + this.sizeLe(x.right, hi);
                break;
            }
            if (hi.compareTo(x.key) < 0) {
                x = x.left;
                continue;
            }
            res += this.sizeGe(x.left, lo) + 1 + this.sizeLe(x.right, hi);
            break;
        }
        return res;
    }

    public final boolean isEmpty() {
        return this.size() == 0;
    }

    public final boolean isLeaf() {
        return this.size() == 1;
    }

    public final void put(K key, V val) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.root = this.put(this.root, key, val);
    }

    protected final Node<K, V> put(Node<K, V> x, K key, V val) {
        if (x == null) {
            return new Node<K, V>(key, val);
        }
        int cmp = key.compareTo(x.key);
        if (cmp < 0) {
            x.left = this.put(x.left, key, val);
        } else if (cmp > 0) {
            x.right = this.put(x.right, key, val);
        } else {
            x.val = val;
        }
        x.size = this.size(x.left) + this.size(x.right) + 1;
        return x;
    }

    public final V get(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        Node<K, V> x = this.get(this.root, key);
        return x == null ? null : (V)x.val;
    }

    protected final Node<K, V> get(Node<K, V> x, K key) {
        int cmp;
        while (x != null && (cmp = key.compareTo(x.key)) != 0) {
            x = cmp < 0 ? x.left : x.right;
        }
        return x;
    }

    public final K min() {
        return this.root == null ? null : (K)this.min(this.root).key;
    }

    protected final Node<K, V> min(Node<K, V> x) {
        Node l;
        while ((l = x.left) != null) {
            x = l;
        }
        return x;
    }

    public final K max() {
        return this.root == null ? null : (K)this.max(this.root).key;
    }

    protected final Node<K, V> max(Node<K, V> x) {
        Node r;
        while ((r = x.right) != null) {
            x = r;
        }
        return x;
    }

    public final int depth() {
        return this.depth(this.root);
    }

    protected final int depth(Node<K, V> x) {
        if (x == null) {
            return 0;
        }
        return Math.max(this.depth(x.left), this.depth(x.right)) + 1;
    }

    public final K floor(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        Node<K, V> x = this.floor(this.root, key);
        return x == null ? null : (K)x.key;
    }

    protected final Node<K, V> floor(Node<K, V> x, K key) {
        Node<K, V> res = null;
        while (x != null) {
            int cmp = key.compareTo(x.key);
            if (cmp == 0) {
                return x;
            }
            if (cmp < 0) {
                x = x.left;
                continue;
            }
            res = x;
            x = x.right;
        }
        return res;
    }

    public final K ceil(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        Node<K, V> x = this.ceil(this.root, key);
        return x == null ? null : (K)x.key;
    }

    protected final Node<K, V> ceil(Node<K, V> x, K key) {
        Node<K, V> res = null;
        while (x != null) {
            int cmp = key.compareTo(x.key);
            if (cmp == 0) {
                return x;
            }
            if (cmp > 0) {
                x = x.right;
                continue;
            }
            res = x;
            x = x.left;
        }
        return res;
    }

    public final K select(int k) {
        if (k < 1) {
            throw new IllegalArgumentException();
        }
        Node<K, V> x = this.select(this.root, k);
        return x == null ? null : (K)x.key;
    }

    protected final Node<K, V> select(Node<K, V> x, int k) {
        int k0;
        while (x != null && (k0 = k - this.size(x.left) - 1) != 0) {
            if (k0 < 0) {
                x = x.left;
                continue;
            }
            x = x.right;
            k = k0;
        }
        return x;
    }

    public final void deleteMin() {
        if (this.root == null) {
            return;
        }
        this.root = this.deleteMin(this.root);
    }

    protected final Node<K, V> deleteMin(Node<K, V> x) {
        if (x.left == null) {
            return x.right;
        }
        x.left = this.deleteMin(x.left);
        x.size = this.size(x.left) + this.size(x.right) + 1;
        return x;
    }

    public final void deleteMax() {
        if (this.root == null) {
            return;
        }
        this.root = this.deleteMax(this.root);
    }

    protected final Node<K, V> deleteMax(Node<K, V> x) {
        if (x.right == null) {
            return x.left;
        }
        x.right = this.deleteMax(x.right);
        x.size = this.size(x.left) + this.size(x.right) + 1;
        return x;
    }

    public final void delete(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.root = this.delete(this.root, key);
    }

    protected final Node<K, V> delete(Node<K, V> x, K key) {
        if (x == null) {
            return null;
        }
        int cmp = key.compareTo(x.key);
        if (cmp < 0) {
            x.left = this.delete(x.left, key);
        } else if (cmp > 0) {
            x.right = this.delete(x.right, key);
        } else {
            if (x.left == null) {
                return x.right;
            }
            if (x.right == null) {
                return x.left;
            }
            Node<K, V> t = x;
            x = this.min(t.right);
            x.left = t.left;
            x.right = this.deleteMin(t.right);
        }
        x.size = this.size(x.left) + this.size(x.right) + 1;
        return x;
    }

    public final Iterable<K> keys() {
        LLinkedQueue queue = LLinkedQueue.of();
        this.keys(this.root, queue);
        return queue;
    }

    protected final void keys(Node<K, V> x, LLinkedQueue<K> queue) {
        if (x == null) {
            return;
        }
        this.keys(x.left, queue);
        queue.offer(x.key);
        this.keys(x.right, queue);
    }

    public final Iterable<K> keysLe(K hi) {
        if (hi == null) {
            throw new NullPointerException();
        }
        LLinkedQueue queue = LLinkedQueue.of();
        this.keysLe(this.root, queue, hi);
        return queue;
    }

    protected final void keysLe(Node<K, V> x, LLinkedQueue<K> queue, K hi) {
        if (x == null) {
            return;
        }
        int cmp = hi.compareTo(x.key);
        if (cmp < 0) {
            this.keysLe(x.left, queue, hi);
        } else {
            this.keys(x.left, queue);
            queue.offer(x.key);
            this.keysLe(x.right, queue, hi);
        }
    }

    public final Iterable<K> keysGe(K lo) {
        if (lo == null) {
            throw new NullPointerException();
        }
        LLinkedQueue queue = LLinkedQueue.of();
        this.keysGe(this.root, queue, lo);
        return queue;
    }

    protected final void keysGe(Node<K, V> x, LLinkedQueue<K> queue, K lo) {
        if (x == null) {
            return;
        }
        int cmp = lo.compareTo(x.key);
        if (cmp > 0) {
            this.keysGe(x.right, queue, lo);
        } else {
            this.keysGe(x.left, queue, lo);
            queue.offer(x.key);
            this.keys(x.right, queue);
        }
    }

    public final Iterable<K> keys(K lo, K hi) {
        if (lo == null || hi == null) {
            throw new NullPointerException();
        }
        if (lo.compareTo(hi) > 0) {
            throw new IllegalArgumentException();
        }
        LLinkedQueue queue = LLinkedQueue.of();
        this.keys(this.root, queue, lo, hi);
        return queue;
    }

    protected final void keys(Node<K, V> x, LLinkedQueue<K> queue, K lo, K hi) {
        if (x == null) {
            return;
        }
        int cmp_lo = lo.compareTo(x.key);
        if (cmp_lo > 0) {
            this.keys(x.right, queue, lo, hi);
        } else if (cmp_lo == 0) {
            queue.offer(x.key);
            this.keysLe(x.right, queue, hi);
        } else {
            int cmp_hi = hi.compareTo(x.key);
            if (cmp_hi >= 0) {
                this.keysGe(x.left, queue, lo);
                queue.offer(x.key);
                this.keysLe(x.right, queue, hi);
            } else {
                this.keys(x.left, queue, lo, hi);
            }
        }
    }

    protected static class Node<K extends Comparable<K>, V> {
        public K key;
        public V val;
        public Node<K, V> left;
        public Node<K, V> right;
        public int size = 1;

        public Node(K key, V val) {
            this.key = key;
            this.val = val;
        }
    }
}

