/*
 * Decompiled with CFR 0.152.
 */
package shz.st.bst;

import java.util.Comparator;
import java.util.function.Consumer;
import java.util.function.Supplier;

public abstract class LWBST<E> {
    protected final Comparator<? super E> comparator;
    protected final E[] leaf;
    protected final int[] tree;
    private final Consumer<E> offer;

    private LWBST(Comparator<? super E> comparator, E[] leaf, int type) {
        if (comparator == null || leaf == null || leaf.length == 0) {
            throw new NullPointerException();
        }
        this.comparator = comparator;
        this.leaf = leaf;
        this.tree = this.getTree(type);
        this.offer = this.getOffer(type);
    }

    protected abstract int[] getTree(int var1);

    protected abstract Consumer<E> getOffer(int var1);

    public static <E> LWBST<E> of(Comparator<? super E> comparator, E[] leaf, int type) {
        return new LWBST<E>((Comparator)comparator, (Object[])leaf, type){

            @Override
            protected int[] getTree(int type) {
                int[] tree;
                if (type == 1) {
                    tree = new int[this.leaf.length << 1];
                    for (int i = 0; i < this.leaf.length; ++i) {
                        tree[this.leaf.length + i] = i;
                    }
                    tree[0] = this.postVisit1(tree, 1);
                } else {
                    tree = new int[(this.leaf.length << 1) - 1];
                    for (int i = 0; i < this.leaf.length; ++i) {
                        tree[this.leaf.length - 1 + i] = i;
                    }
                    this.postVisit0(tree, 0);
                }
                return tree;
            }

            private int postVisit1(int[] tree, int i) {
                int ri;
                int left = i << 1;
                int lwinner = -1;
                int rwinner = -1;
                if (left < this.leaf.length) {
                    lwinner = this.postVisit1(tree, left);
                }
                if (left < this.leaf.length - 1) {
                    rwinner = this.postVisit1(tree, left + 1);
                }
                int li = lwinner < 0 ? tree[i << 1] : lwinner;
                int n = ri = rwinner < 0 ? tree[(i << 1) + 1] : rwinner;
                if (this.leaf[li] == null) {
                    tree[i] = li;
                    return ri;
                }
                if (this.leaf[ri] == null) {
                    tree[i] = ri;
                    return li;
                }
                if (this.comparator.compare(this.leaf[li], this.leaf[ri]) < 0) {
                    tree[i] = ri;
                    return li;
                }
                tree[i] = li;
                return ri;
            }

            private void postVisit0(int[] tree, int i) {
                int left = (i << 1) + 1;
                if (left < this.leaf.length - 1) {
                    this.postVisit0(tree, left);
                }
                if (left < this.leaf.length - 2) {
                    this.postVisit0(tree, left + 1);
                }
                int li = tree[(i << 1) + 1];
                int ri = tree[(i << 1) + 2];
                if (this.leaf[li] != null || this.leaf[ri] != null) {
                    tree[i] = this.leaf[li] == null || this.leaf[ri] != null && this.comparator.compare(this.leaf[li], this.leaf[ri]) >= 0 ? ri : li;
                }
            }

            @Override
            protected Consumer<E> getOffer(int type) {
                Consumer<Object> offer = type == 1 ? e -> {
                    this.leaf[this.tree[0]] = e;
                    int winner = this.tree[0];
                    for (int parent = this.tree[0] + this.leaf.length >> 1; parent > 0; parent >>= 1) {
                        if (this.leaf[this.tree[parent]] == null || this.leaf[winner] != null && this.comparator.compare(this.leaf[winner], this.leaf[this.tree[parent]]) <= 0) continue;
                        int loser = this.tree[parent];
                        this.tree[parent] = winner;
                        winner = loser;
                    }
                    this.tree[0] = winner;
                } : e -> {
                    this.leaf[this.tree[0]] = e;
                    int parent = this.tree[0] + this.leaf.length - 2 >> 1;
                    while (parent >= 0) {
                        int li = this.tree[(parent << 1) + 1];
                        int ri = this.tree[(parent << 1) + 2];
                        if (this.leaf[li] != null || this.leaf[ri] != null) {
                            this.tree[parent] = this.leaf[li] == null || this.leaf[ri] != null && this.comparator.compare(this.leaf[li], this.leaf[ri]) >= 0 ? ri : li;
                        }
                        parent = parent - 1 >> 1;
                    }
                };
                return offer;
            }
        };
    }

    public static <E> LWBST<E> of(Comparator<? super E> comparator, E[] leaf) {
        return LWBST.of(comparator, leaf, 1);
    }

    public final void sort(Supplier<E>[] sources, Consumer<E> consumer) {
        if (sources == null || consumer == null) {
            throw new NullPointerException();
        }
        if (sources.length != this.leaf.length) {
            throw new IllegalArgumentException();
        }
        while (this.leaf[this.tree[0]] != null) {
            consumer.accept(this.leaf[this.tree[0]]);
            this.offer.accept(sources[this.tree[0]].get());
        }
    }
}

