/*
 * Decompiled with CFR 0.152.
 */
package shz.st.bst;

public abstract class RedBlackBST<K extends Comparable<K>> {
    protected Node root;

    protected RedBlackBST(Node root) {
        if (root == null) {
            throw new NullPointerException();
        }
        this.root = root;
    }

    protected final <T extends Node> T root() {
        return (T)this.root;
    }

    public final int size() {
        return this.size(this.root);
    }

    protected final int size(Node h) {
        return h == null ? 0 : h.size;
    }

    public final boolean isEmpty() {
        return this.size() == 0;
    }

    public final boolean isLeaf() {
        return this.size() == 1;
    }

    protected final boolean isRed(Node h) {
        return h != null && h.red;
    }

    protected final <T extends Node> T rotateLeft(Node h) {
        Node x = h.right;
        h.right = x.left;
        x.left = h;
        x.red = h.red;
        h.red = true;
        x.size = h.size;
        h.size = 1 + this.size(h.left) + this.size(h.right);
        return (T)x;
    }

    protected final <T extends Node> T rotateRight(Node h) {
        Node x = h.left;
        h.left = x.right;
        x.right = h;
        x.red = h.red;
        h.red = true;
        x.size = h.size;
        h.size = 1 + this.size(h.left) + this.size(h.right);
        return (T)x;
    }

    protected final void flipColors(Node h) {
        h.red = true;
        if (h.left != null) {
            h.left.red = false;
        }
        if (h.right != null) {
            h.right.red = false;
        }
    }

    protected abstract K key(Node var1);

    public final K min() {
        return this.root == null ? null : (K)this.key((Node)this.min(this.root));
    }

    protected final <T extends Node> T min(Node h) {
        Node l;
        while ((l = h.left) != null) {
            h = l;
        }
        return (T)h;
    }

    public final K max() {
        return this.root == null ? null : (K)this.key((Node)this.max(this.root));
    }

    protected final <T extends Node> T max(Node h) {
        Node r;
        while ((r = h.right) != null) {
            h = r;
        }
        return (T)h;
    }

    public final int depth() {
        return this.depth(this.root);
    }

    protected final int depth(Node h) {
        if (h == null) {
            return 0;
        }
        return Math.max(this.depth(h.left), this.depth(h.right)) + 1;
    }

    public final K select(int k) {
        if (k < 1) {
            throw new IllegalArgumentException();
        }
        Object h = this.select(this.root, k);
        return h == null ? null : (K)this.key((Node)h);
    }

    protected final <T extends Node> T select(Node h, int k) {
        int k0;
        while (h != null && (k0 = k - this.size(h.left) - 1) != 0) {
            if (k0 < 0) {
                h = h.left;
                continue;
            }
            h = h.right;
            k = k0;
        }
        return (T)h;
    }

    public final void deleteMin() {
        if (this.root == null) {
            return;
        }
        if (!this.isRed(this.root.left) && !this.isRed(this.root.right)) {
            this.root.red = true;
        }
        this.root = this.deleteMin(this.root);
        if (this.root == null) {
            return;
        }
        if (!this.isEmpty()) {
            this.root.red = false;
        }
    }

    protected final <T extends Node> T deleteMin(Node h) {
        if (h.left == null) {
            return h.right();
        }
        if (!this.isRed(h.left) && !this.isRed(h.left.left)) {
            h = this.moveRedLeft(h);
        }
        h.left = this.deleteMin(h.left);
        return this.balance(h);
    }

    protected final <T extends Node> T moveRedLeft(Node h) {
        this.flipColors(h);
        if (h.right != null && this.isRed(h.right.left)) {
            h.right = this.rotateRight(h.right);
            h = this.rotateLeft(h);
        }
        return (T)h;
    }

    protected final <T extends Node> T balance(Node h) {
        if (this.isRed(h.right)) {
            h = this.rotateLeft(h);
        }
        if (this.isRed(h.right) && !this.isRed(h.left)) {
            h = this.rotateLeft(h);
        }
        if (this.isRed(h.left) && this.isRed(h.left.left)) {
            h = this.rotateRight(h);
        }
        if (this.isRed(h.left) && this.isRed(h.right)) {
            this.flipColors(h);
        }
        h.size = this.size(h.left) + this.size(h.right) + 1;
        return (T)h;
    }

    public final void deleteMax() {
        if (this.root == null) {
            return;
        }
        if (!this.isRed(this.root.left) && !this.isRed(this.root.right)) {
            this.root.red = true;
        }
        this.root = this.deleteMax(this.root);
        if (this.root == null) {
            return;
        }
        if (!this.isEmpty()) {
            this.root.red = false;
        }
    }

    protected final <T extends Node> T deleteMax(Node h) {
        if (this.isRed(h.left)) {
            h = this.rotateRight(h);
        }
        if (h.right == null) {
            return h.left();
        }
        if (!this.isRed(h.right) && !this.isRed(h.right.left)) {
            h = this.moveRedRight(h);
        }
        h.right = this.deleteMax(h.right);
        return this.balance(h);
    }

    protected final <T extends Node> T moveRedRight(Node h) {
        this.flipColors(h);
        if (h.left != null && !this.isRed(h.left.left)) {
            h = this.rotateRight(h);
        }
        return (T)h;
    }

    protected static abstract class Node {
        public Node left;
        public Node right;
        public int size = 1;
        public boolean red;

        public Node(boolean red) {
            this.red = red;
        }

        public final <T extends Node> T left() {
            return (T)this.left;
        }

        public final <T extends Node> T right() {
            return (T)this.right;
        }
    }
}

