/*
 * Decompiled with CFR 0.152.
 */
package shz.st.bst.ixx;

import shz.st.bst.ixx.IXXRedBlackBST;

public class IJRedBlackBST
extends IXXRedBlackBST {
    protected IJRedBlackBST(int key, long val) {
        super(new Node(key, val, false));
    }

    public static IJRedBlackBST of(int key, long val) {
        return new IJRedBlackBST(key, val);
    }

    public static IJRedBlackBST of(int key) {
        return IJRedBlackBST.of(key, 0L);
    }

    public final void put(int key, long val) {
        this.root = this.put((Node)this.root(), key, val);
        this.root.red = false;
    }

    protected final Node put(Node h, int key, long val) {
        if (h == null) {
            return new Node(key, val);
        }
        if (key < h.key) {
            h.left = this.put((Node)h.left(), key, val);
        } else if (key > h.key) {
            h.right = this.put((Node)h.right(), key, val);
        } else {
            h.val = val;
        }
        if (this.isRed(h.right) && !this.isRed(h.left)) {
            h = (Node)this.rotateLeft(h);
        }
        if (this.isRed(h.left) && this.isRed(h.left.left)) {
            h = (Node)this.rotateRight(h);
        }
        if (this.isRed(h.left) && this.isRed(h.right)) {
            this.flipColors(h);
        }
        h.size = this.size(h.left) + this.size(h.right) + 1;
        return h;
    }

    public final Long get(int key) {
        Node h = this.get((Node)this.root(), key);
        return h == null ? null : Long.valueOf(h.val);
    }

    protected final Node get(Node h, int key) {
        while (h != null && key != h.key) {
            h = key < h.key ? (Node)h.left() : (Node)h.right();
        }
        return h;
    }

    public final void delete(int key) {
        if (this.root == null) {
            return;
        }
        if (!this.isRed(this.root.left) && !this.isRed(this.root.right)) {
            this.root.red = true;
        }
        this.root = this.delete((Node)this.root(), key);
        if (this.root == null) {
            return;
        }
        if (!this.isEmpty()) {
            this.root.red = false;
        }
    }

    protected final Node delete(Node h, int key) {
        if (key < h.key) {
            if (!this.isRed(h.left) && !this.isRed(h.left.left)) {
                h = (Node)this.moveRedLeft(h);
            }
            h.left = this.delete((Node)h.left(), key);
        } else {
            if (this.isRed(h.left)) {
                h = (Node)this.rotateRight(h);
            }
            if (key == h.key && h.right == null) {
                return null;
            }
            if (!this.isRed(h.right) && !this.isRed(h.right.left)) {
                h = (Node)this.moveRedRight(h);
            }
            if (key == h.key) {
                Node min = (Node)this.min(h.right);
                h.val = this.get((Node)((Node)h.right()), (int)min.key).val;
                h.key = min.key;
                h.right = this.deleteMin(h.right);
            } else {
                h.right = this.delete((Node)h.right(), key);
            }
        }
        return (Node)this.balance(h);
    }

    protected static final class Node
    extends IXXRedBlackBST.Node {
        public long val;

        public Node(int key, long val, boolean red) {
            super(key, red);
            this.val = val;
        }

        public Node(int key, long val) {
            this(key, val, true);
        }
    }
}

