/*
 * Decompiled with CFR 0.152.
 */
package shz.st.bst.lxx;

import shz.st.bst.lxx.LXXRedBlackBST;

public class LDRedBlackBST<K extends Comparable<K>>
extends LXXRedBlackBST<K> {
    protected LDRedBlackBST(K key, double val) {
        super(new Node<K>(key, val, false));
    }

    public static <K extends Comparable<K>> LDRedBlackBST<K> of(K key, double val) {
        if (key == null) {
            throw new NullPointerException();
        }
        return new LDRedBlackBST<K>(key, val);
    }

    public static <K extends Comparable<K>> LDRedBlackBST<K> of(K key) {
        return LDRedBlackBST.of(key, 0.0);
    }

    public final void put(K key, double val) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.root = this.put((Node)this.root(), key, val);
        this.root.red = false;
    }

    protected final Node<K> put(Node<K> h, K key, double val) {
        if (h == null) {
            return new Node<K>(key, val);
        }
        int cmp = key.compareTo((Comparable)h.key);
        if (cmp < 0) {
            h.left = this.put((Node)h.left(), key, val);
        } else if (cmp > 0) {
            h.right = this.put((Node)h.right(), key, val);
        } else {
            h.val = val;
        }
        if (this.isRed(h.right) && !this.isRed(h.left)) {
            h = (Node)this.rotateLeft(h);
        }
        if (this.isRed(h.left) && this.isRed(h.left.left)) {
            h = (Node)this.rotateRight(h);
        }
        if (this.isRed(h.left) && this.isRed(h.right)) {
            this.flipColors(h);
        }
        h.size = this.size(h.left) + this.size(h.right) + 1;
        return h;
    }

    public final Double get(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        Node<K> h = this.get((Node)this.root(), key);
        return h == null ? null : Double.valueOf(h.val);
    }

    protected final Node<K> get(Node<K> h, K key) {
        int cmp;
        while (h != null && (cmp = key.compareTo((Comparable)h.key)) != 0) {
            h = cmp < 0 ? (Node)h.left() : (Node)h.right();
        }
        return h;
    }

    public final void delete(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (this.root == null) {
            return;
        }
        if (!this.isRed(this.root.left) && !this.isRed(this.root.right)) {
            this.root.red = true;
        }
        this.root = this.delete((Node)this.root(), key);
        if (this.root == null) {
            return;
        }
        if (!this.isEmpty()) {
            this.root.red = false;
        }
    }

    protected final Node<K> delete(Node<K> h, K key) {
        int cmp = key.compareTo((Comparable)h.key);
        if (cmp < 0) {
            if (!this.isRed(h.left) && !this.isRed(h.left.left)) {
                h = (Node)this.moveRedLeft(h);
            }
            h.left = this.delete((Node)h.left(), key);
        } else {
            if (this.isRed(h.left)) {
                h = (Node)this.rotateRight(h);
            }
            if (cmp == 0 && h.right == null) {
                return null;
            }
            if (!this.isRed(h.right) && !this.isRed(h.right.left)) {
                h = (Node)this.moveRedRight(h);
            }
            if (cmp == 0) {
                Node min = (Node)this.min(h.right);
                h.val = this.get((Node)h.right(), min.key).val;
                h.key = min.key;
                h.right = this.deleteMin(h.right);
            } else {
                h.right = this.delete((Node)h.right(), key);
            }
        }
        return (Node)this.balance(h);
    }

    protected static final class Node<K extends Comparable<K>>
    extends LXXRedBlackBST.Node<K> {
        public double val;

        public Node(K key, double val, boolean red) {
            super(key, red);
            this.val = val;
        }

        public Node(K key, double val) {
            this(key, val, true);
        }
    }
}

