/*
 * Decompiled with CFR 0.152.
 */
package shz.st.bst.lxx;

import shz.st.bst.lxx.LXXRedBlackBST;

public class LLRedBlackBST<K extends Comparable<K>, V>
extends LXXRedBlackBST<K> {
    protected LLRedBlackBST(K key, V val) {
        super(new Node<K, V>(key, val, false));
    }

    public static <K extends Comparable<K>, V> LLRedBlackBST<K, V> of(K key, V val) {
        if (key == null) {
            throw new NullPointerException();
        }
        return new LLRedBlackBST<K, V>(key, val);
    }

    public static <K extends Comparable<K>, V> LLRedBlackBST<K, V> of(K key) {
        return LLRedBlackBST.of(key, null);
    }

    public final void put(K key, V val) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.root = this.put((Node)this.root(), key, val);
        this.root.red = false;
    }

    protected final Node<K, V> put(Node<K, V> h, K key, V val) {
        if (h == null) {
            return new Node<K, V>(key, val);
        }
        int cmp = key.compareTo((Comparable)h.key);
        if (cmp < 0) {
            h.left = this.put((Node)h.left(), key, val);
        } else if (cmp > 0) {
            h.right = this.put((Node)h.right(), key, val);
        } else {
            h.val = val;
        }
        if (this.isRed(h.right) && !this.isRed(h.left)) {
            h = (Node)this.rotateLeft(h);
        }
        if (this.isRed(h.left) && this.isRed(h.left.left)) {
            h = (Node)this.rotateRight(h);
        }
        if (this.isRed(h.left) && this.isRed(h.right)) {
            this.flipColors(h);
        }
        h.size = this.size(h.left) + this.size(h.right) + 1;
        return h;
    }

    public final V get(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        Node<K, V> h = this.get((Node)this.root(), key);
        return h == null ? null : (V)h.val;
    }

    protected final Node<K, V> get(Node<K, V> h, K key) {
        int cmp;
        while (h != null && (cmp = key.compareTo((Comparable)h.key)) != 0) {
            h = cmp < 0 ? (Node)h.left() : (Node)h.right();
        }
        return h;
    }

    public final void delete(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (this.root == null) {
            return;
        }
        if (!this.isRed(this.root.left) && !this.isRed(this.root.right)) {
            this.root.red = true;
        }
        this.root = this.delete((Node)this.root(), key);
        if (this.root == null) {
            return;
        }
        if (!this.isEmpty()) {
            this.root.red = false;
        }
    }

    protected final Node<K, V> delete(Node<K, V> h, K key) {
        int cmp = key.compareTo((Comparable)h.key);
        if (cmp < 0) {
            if (!this.isRed(h.left) && !this.isRed(h.left.left)) {
                h = (Node)this.moveRedLeft(h);
            }
            h.left = this.delete((Node)h.left(), key);
        } else {
            if (this.isRed(h.left)) {
                h = (Node)this.rotateRight(h);
            }
            if (cmp == 0 && h.right == null) {
                return null;
            }
            if (!this.isRed(h.right) && !this.isRed(h.right.left)) {
                h = (Node)this.moveRedRight(h);
            }
            if (cmp == 0) {
                Node min = (Node)this.min(h.right);
                h.val = this.get((Node)h.right(), min.key).val;
                h.key = min.key;
                h.right = this.deleteMin(h.right);
            } else {
                h.right = this.delete((Node)h.right(), key);
            }
        }
        return (Node)this.balance(h);
    }

    protected static final class Node<K extends Comparable<K>, V>
    extends LXXRedBlackBST.Node<K> {
        public V val;

        public Node(K key, V val, boolean red) {
            super(key, red);
            this.val = val;
        }

        public Node(K key, V val) {
            this(key, val, true);
        }
    }
}

