/*
 * Decompiled with CFR 0.152.
 */
package shz.st.bst.lxx;

import shz.queue.LLinkedQueue;
import shz.st.bst.RedBlackBST;

public abstract class LXXRedBlackBST<K extends Comparable<K>>
extends RedBlackBST<K> {
    protected LXXRedBlackBST(Node<K> root) {
        super(root);
    }

    @Override
    protected final K key(RedBlackBST.Node h) {
        return ((Node)h).key;
    }

    public final int sizeLe(K hi) {
        if (hi == null) {
            throw new NullPointerException();
        }
        return this.sizeLe((Node)this.root(), hi);
    }

    protected final int sizeLe(Node<K> h, K hi) {
        int res = 0;
        while (h != null) {
            if (hi.compareTo(h.key) < 0) {
                h = (Node)h.left();
                continue;
            }
            res += 1 + this.size((RedBlackBST.Node)h.left());
            h = (Node)h.right();
        }
        return res;
    }

    public final int sizeGe(K lo) {
        if (lo == null) {
            throw new NullPointerException();
        }
        return this.sizeGe((Node)this.root(), lo);
    }

    protected final int sizeGe(Node<K> h, K lo) {
        int res = 0;
        while (h != null) {
            if (lo.compareTo(h.key) > 0) {
                h = (Node)h.right();
                continue;
            }
            res += 1 + this.size((RedBlackBST.Node)h.right());
            h = (Node)h.left();
        }
        return res;
    }

    public final int size(K lo, K hi) {
        if (lo == null || hi == null) {
            throw new NullPointerException();
        }
        if (lo.compareTo(hi) > 0) {
            throw new IllegalArgumentException();
        }
        return this.size((Node)this.root(), lo, hi);
    }

    protected final int size(Node<K> h, K lo, K hi) {
        int res = 0;
        while (h != null) {
            int cmp = lo.compareTo(h.key);
            if (cmp > 0) {
                h = (Node)h.right();
                continue;
            }
            if (cmp == 0) {
                res += 1 + this.sizeLe((Node)h.right(), hi);
                break;
            }
            if (hi.compareTo(h.key) < 0) {
                h = (Node)h.left();
                continue;
            }
            res += this.sizeGe((Node)h.left(), lo) + 1 + this.sizeLe((Node)h.right(), hi);
            break;
        }
        return res;
    }

    public final K floor(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        Node<K> h = this.floor((Node)this.root(), key);
        return h == null ? null : (K)h.key;
    }

    protected final Node<K> floor(Node<K> h, K key) {
        Node res = null;
        while (h != null) {
            int cmp = key.compareTo(h.key);
            if (cmp == 0) {
                return h;
            }
            if (cmp < 0) {
                h = (Node)h.left();
                continue;
            }
            res = h;
            h = (Node)h.right();
        }
        return res;
    }

    public final K ceil(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        Node<K> h = this.ceil((Node)this.root(), key);
        return h == null ? null : (K)h.key;
    }

    protected final Node<K> ceil(Node<K> h, K key) {
        Node res = null;
        while (h != null) {
            int cmp = key.compareTo(h.key);
            if (cmp == 0) {
                return h;
            }
            if (cmp > 0) {
                h = (Node)h.right();
                continue;
            }
            res = h;
            h = (Node)h.left();
        }
        return res;
    }

    public final Iterable<K> keys() {
        LLinkedQueue queue = LLinkedQueue.of();
        this.keys((Node)this.root(), queue);
        return queue;
    }

    protected final void keys(Node<K> h, LLinkedQueue<K> queue) {
        if (h == null) {
            return;
        }
        this.keys((Node)h.left(), queue);
        queue.offer(h.key);
        this.keys((Node)h.right(), queue);
    }

    public final Iterable<K> keysLe(K hi) {
        if (hi == null) {
            throw new NullPointerException();
        }
        LLinkedQueue queue = LLinkedQueue.of();
        this.keysLe((Node)this.root(), queue, hi);
        return queue;
    }

    protected final void keysLe(Node<K> h, LLinkedQueue<K> queue, K hi) {
        if (h == null) {
            return;
        }
        if (hi.compareTo(h.key) < 0) {
            this.keysLe((Node)h.left(), queue, hi);
        } else {
            this.keys((Node)h.left(), queue);
            queue.offer(h.key);
            this.keysLe((Node)h.right(), queue, hi);
        }
    }

    public final Iterable<K> keysGe(K lo) {
        if (lo == null) {
            throw new NullPointerException();
        }
        LLinkedQueue queue = LLinkedQueue.of();
        this.keysGe((Node)this.root(), queue, lo);
        return queue;
    }

    protected final void keysGe(Node<K> h, LLinkedQueue<K> queue, K lo) {
        if (h == null) {
            return;
        }
        if (lo.compareTo(h.key) > 0) {
            this.keysGe((Node)h.right(), queue, lo);
        } else {
            this.keysGe((Node)h.left(), queue, lo);
            queue.offer(h.key);
            this.keys((Node)h.right(), queue);
        }
    }

    public final Iterable<K> keys(K lo, K hi) {
        if (lo == null || hi == null) {
            throw new NullPointerException();
        }
        if (lo.compareTo(hi) > 0) {
            throw new IllegalArgumentException();
        }
        LLinkedQueue queue = LLinkedQueue.of();
        this.keys((Node)this.root(), queue, lo, hi);
        return queue;
    }

    protected final void keys(Node<K> h, LLinkedQueue<K> queue, K lo, K hi) {
        if (h == null) {
            return;
        }
        int cmp = lo.compareTo(h.key);
        if (cmp > 0) {
            this.keys((Node)h.right(), queue, lo, hi);
        } else if (cmp == 0) {
            queue.offer(h.key);
            this.keysLe((Node)h.right(), queue, hi);
        } else if (hi.compareTo(h.key) >= 0) {
            this.keysGe((Node)h.left(), queue, lo);
            queue.offer(h.key);
            this.keysLe((Node)h.right(), queue, hi);
        } else {
            this.keys((Node)h.left(), queue, lo, hi);
        }
    }

    protected static abstract class Node<K extends Comparable<K>>
    extends RedBlackBST.Node {
        protected K key;

        protected Node(K key, boolean red) {
            super(red);
            this.key = key;
        }
    }
}

