/*
 * Decompiled with CFR 0.152.
 */
package shz.st.hst;

import shz.st.hst.HST;

public class LinearProbingHST<K, V>
extends HST {
    protected K[] keys;
    protected V[] vales;

    protected LinearProbingHST(int capacity) {
        super(capacity);
        this.keys = new Object[capacity];
        this.vales = new Object[capacity];
    }

    public static <K, V> LinearProbingHST<K, V> of(int capacity) {
        return new LinearProbingHST<K, V>(capacity);
    }

    public static <K, V> LinearProbingHST<K, V> of() {
        return LinearProbingHST.of(16);
    }

    @Override
    protected final void resize(int capacity) {
        LinearProbingHST<K, V> t = LinearProbingHST.of(capacity);
        for (int i = 0; i < this.capacity; ++i) {
            if (this.keys[i] == null) continue;
            t.put(this.keys[i], this.vales[i]);
        }
        this.keys = t.keys;
        this.vales = t.vales;
        this.capacity = t.capacity;
    }

    public final void put(K key, V val) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.beforePut();
        int i = this.hash(key);
        while (this.keys[i] != null) {
            if (this.keys[i].equals(key)) {
                this.vales[i] = val;
                return;
            }
            i = (i + 1) % this.capacity;
        }
        this.keys[i] = key;
        this.vales[i] = val;
        ++this.size;
    }

    protected final int hash(K key) {
        return (key.hashCode() & Integer.MAX_VALUE) % this.capacity;
    }

    public final V get(K key) {
        int i = this.hash(key);
        while (this.keys[i] != null) {
            if (this.keys[i].equals(key)) {
                return this.vales[i];
            }
            i = (i + 1) % this.capacity;
        }
        return null;
    }

    public final boolean containsKey(K key) {
        int i = this.hash(key);
        while (this.keys[i] != null) {
            if (this.keys[i].equals(key)) {
                return true;
            }
            i = (i + 1) % this.capacity;
        }
        return false;
    }

    public final void delete(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        int i = this.hash(key);
        while (this.keys[i] != null && !this.keys[i].equals(key)) {
            i = (i + 1) % this.capacity;
        }
        if (this.keys[i] == null) {
            return;
        }
        this.keys[i] = null;
        this.vales[i] = null;
        i = (i + 1) % this.capacity;
        while (this.keys[i] != null) {
            K keyToRedo = this.keys[i];
            V valToRedo = this.vales[i];
            this.keys[i] = null;
            this.vales[i] = null;
            --this.size;
            this.put(keyToRedo, valToRedo);
            i = (i + 1) % this.capacity;
        }
        --this.size;
        if (this.size > 0 && this.size <= this.capacity >>> 3) {
            this.resize(this.capacity >> 1);
        }
    }
}

