/*
 * Decompiled with CFR 0.152.
 */
package shz.st.triest;

import java.util.Collections;
import java.util.function.Predicate;
import shz.queue.FArrayQueue;
import shz.st.triest.TrieST;
import shz.stack.LLinkedStack;

public class FTrieST
extends TrieST {
    protected FTrieST(char[] chars) {
        super(chars);
        this.root = new Node(chars.length);
    }

    public static FTrieST of(char[] chars) {
        if (chars == null || chars.length == 0) {
            throw new NullPointerException();
        }
        return new FTrieST(chars);
    }

    public final void put(char[] a, float val) {
        this.check(a);
        Node x = (Node)this.root();
        for (char c : a) {
            int i = this.idx(c);
            if (x.next[i] == null) {
                x.next[i] = new Node(this.chars.length);
            }
            x = (Node)x.next(i);
        }
        x.val = val;
        x.leaf = true;
    }

    public final Float get(char[] a) {
        this.check(a);
        Node x = (Node)this.get(this.root, a, a.length);
        return x == null || !x.leaf ? null : Float.valueOf(x.val);
    }

    public final Iterable<Float> getAll() {
        return this.get((Node)this.root());
    }

    protected final Iterable<Float> get(Node x) {
        FArrayQueue queue = FArrayQueue.of();
        LLinkedStack<Node> stack = LLinkedStack.of();
        this.push(stack, x);
        while (stack.size() > 0) {
            Node pop = stack.pop();
            if (pop.leaf) {
                queue.offer(pop.val);
            }
            this.push(stack, pop);
        }
        return queue.isEmpty() ? Collections.emptyList() : queue;
    }

    private void push(LLinkedStack<Node> stack, Node x) {
        if (x.next == null) {
            return;
        }
        for (int i = 0; i < this.chars.length; ++i) {
            if (x.next[i] == null) continue;
            stack.push((Node)x.next(i));
        }
    }

    public final Iterable<Float> getByPrefix(char[] prefix) {
        this.check(prefix);
        Node x = (Node)this.get(this.root, prefix, prefix.length);
        if (x == null) {
            return Collections.emptyList();
        }
        return this.get(x);
    }

    public final Iterable<char[]> getChars(Predicate<Float> predicate, int limit) {
        return this.getChars0(x -> predicate == null || predicate.test(Float.valueOf(((Node)x).val)), limit);
    }

    protected static final class Node
    extends TrieST.Node {
        public float val;

        public Node(int r) {
            super(r);
        }
    }
}

