/*
 * Decompiled with CFR 0.152.
 */
package shz.st.triest;

import java.util.Collections;
import java.util.function.Predicate;
import shz.queue.LLinkedQueue;
import shz.st.triest.TrieST;
import shz.stack.LLinkedStack;

public class LTrieST<E>
extends TrieST {
    protected LTrieST(char[] chars) {
        super(chars);
        this.root = new Node(chars.length);
    }

    public static <E> LTrieST<E> of(char[] chars) {
        if (chars == null || chars.length == 0) {
            throw new NullPointerException();
        }
        return new LTrieST<E>(chars);
    }

    public final void put(char[] a, E val) {
        if (val == null) {
            throw new NullPointerException();
        }
        this.check(a);
        Node x = (Node)this.root();
        for (char c : a) {
            int i = this.idx(c);
            if (x.next[i] == null) {
                x.next[i] = new Node(this.chars.length);
            }
            x = (Node)x.next(i);
        }
        x.val = val;
        x.leaf = true;
    }

    public final E get(char[] a) {
        this.check(a);
        Node x = (Node)this.get(this.root, a, a.length);
        return x == null || !x.leaf ? null : (E)x.val;
    }

    public final Iterable<E> getAll() {
        return this.get((Node)this.root());
    }

    protected final Iterable<E> get(Node<E> x) {
        LLinkedQueue queue = LLinkedQueue.of();
        LLinkedStack<Node<E>> stack = LLinkedStack.of();
        this.push(stack, x);
        while (stack.size() > 0) {
            Node<E> pop = stack.pop();
            if (pop.leaf) {
                queue.offer(pop.val);
            }
            this.push(stack, pop);
        }
        return queue.isEmpty() ? Collections.emptyList() : queue;
    }

    private void push(LLinkedStack<Node<E>> stack, Node<E> x) {
        if (x.next == null) {
            return;
        }
        for (int i = 0; i < this.chars.length; ++i) {
            if (x.next[i] == null) continue;
            stack.push(x.next(i));
        }
    }

    public final Iterable<E> getByPrefix(char[] prefix) {
        this.check(prefix);
        Node x = (Node)this.get(this.root, prefix, prefix.length);
        if (x == null) {
            return Collections.emptyList();
        }
        return this.get(x);
    }

    public final Iterable<char[]> getChars(Predicate<E> predicate, int limit) {
        return this.getChars0(x -> predicate == null || predicate.test(((Node)x).val), limit);
    }

    protected static final class Node<E>
    extends TrieST.Node {
        public E val;

        public Node(int r) {
            super(r);
        }
    }
}

