/*
 * Decompiled with CFR 0.152.
 */
package shz.st.triest;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Predicate;
import shz.queue.CArrayQueue;
import shz.queue.LLinkedQueue;
import shz.stack.LLinkedStack;
import shz.stack.ZArrayStack;
import shz.tuple.Tuple2;

public abstract class TrieST {
    protected final char[] chars;
    protected Node root;
    private static final char[] ZERO = new char[]{'0'};
    private static final char[] MIN_VALUE = new char[]{'1', '0'};

    protected TrieST(char[] chars) {
        this.chars = chars;
    }

    protected final <T extends Node> T root() {
        return (T)this.root;
    }

    protected final void check(char[] a) {
        if (a == null || a.length == 0) {
            throw new NullPointerException();
        }
        for (char c : a) {
            if (this.idx(c) != -1) continue;
            throw new IllegalStateException();
        }
    }

    protected final int idx(char c) {
        for (int i = 0; i < this.chars.length; ++i) {
            if (this.chars[i] != c) continue;
            return i;
        }
        return -1;
    }

    protected final <T extends Node> T get(Node x, char[] a, int d) {
        for (int i = 0; i < d && (x = x.next[this.idx(a[i])]) != null; ++i) {
        }
        return (T)x;
    }

    public final void delete(char[] a) {
        this.check(a);
        Object p = this.get(this.root, a, a.length - 1);
        if (p == null) {
            return;
        }
        int i = this.idx(a[a.length - 1]);
        Node x = ((Node)p).next[i];
        if (x == null) {
            return;
        }
        x.leaf = false;
        if (x.next == null) {
            ((Node)p).next[i] = null;
        }
    }

    protected final Iterable<char[]> getChars0(Predicate<Node> predicate, int limit) {
        LLinkedQueue<char[]> result = LLinkedQueue.of();
        CArrayQueue key = CArrayQueue.of();
        LLinkedStack<Tuple2<Character, Node>> stack = LLinkedStack.of();
        ZArrayStack remove = ZArrayStack.of();
        this.push(stack, this.root, remove);
        while (stack.size() > 0 && (limit <= 0 || result.size() < limit)) {
            Tuple2<Character, Node> pop = stack.pop();
            remove.pop();
            key.offer(((Character)pop._1).charValue());
            if (((Node)pop._2).leaf && predicate.test((Node)pop._2)) {
                char[] chars = new char[key.size()];
                Iterator it = key.iterator();
                int i = 0;
                while (it.hasNext()) {
                    chars[i++] = ((Character)it.next()).charValue();
                }
                result.offer(chars);
            }
            if (this.push(stack, (Node)pop._2, remove)) continue;
            key.removeTail();
            while (remove.size() > 1 && remove.peek()) {
                remove.pop();
                key.removeTail();
            }
        }
        return result.isEmpty() ? Collections.emptyList() : result;
    }

    private boolean push(LLinkedStack<Tuple2<Character, Node>> stack, Node x, ZArrayStack remove) {
        if (x.next == null) {
            return false;
        }
        remove.push(true);
        boolean flag = false;
        for (int i = 0; i < this.chars.length; ++i) {
            if (x.next[i] == null) continue;
            flag = true;
            stack.push(Tuple2.apply(Character.valueOf(this.chars[i]), x.next[i]));
            remove.push(false);
        }
        if (!flag) {
            remove.pop();
        }
        return flag;
    }

    public static char[] toChars(int i) {
        boolean lt0;
        if (i == 0) {
            return ZERO;
        }
        boolean bl = lt0 = i < 0;
        if (lt0) {
            if (i == Integer.MIN_VALUE) {
                return MIN_VALUE;
            }
            i = -i;
        }
        return ((lt0 ? 1 : 0) + Integer.toBinaryString(i)).toCharArray();
    }

    public static char[] toChars(long j) {
        boolean lt0;
        if (j == 0L) {
            return ZERO;
        }
        boolean bl = lt0 = j < 0L;
        if (lt0) {
            if (j == Long.MIN_VALUE) {
                return MIN_VALUE;
            }
            j = -j;
        }
        return ((lt0 ? 1 : 0) + Long.toBinaryString(j)).toCharArray();
    }

    public static int toInt(char[] a) {
        if (a == null || a.length == 0) {
            throw new NullPointerException();
        }
        for (char c : a) {
            if (c == '0' || c == '1') continue;
            throw new IllegalStateException();
        }
        if (a.length == 1) {
            if (a[0] == '0') {
                return 0;
            }
            throw new IllegalArgumentException();
        }
        if (a.length == 2 && a[1] == '0') {
            if (a[0] == '1') {
                return Integer.MIN_VALUE;
            }
            throw new IllegalArgumentException();
        }
        if (a.length > 32) {
            throw new IllegalStateException();
        }
        int num = 0;
        for (int i = 1; i < a.length; ++i) {
            if (a[i] != '1') continue;
            num += 1 << a.length - 1 - i;
        }
        return a[0] == '1' ? -num : num;
    }

    public static long toLong(char[] a) {
        if (a == null || a.length == 0) {
            throw new NullPointerException();
        }
        for (char c : a) {
            if (c == '0' || c == '1') continue;
            throw new IllegalStateException();
        }
        if (a.length == 1) {
            if (a[0] == '0') {
                return 0L;
            }
            throw new IllegalArgumentException();
        }
        if (a.length == 2 && a[1] == '0') {
            if (a[0] == '1') {
                return Long.MIN_VALUE;
            }
            throw new IllegalArgumentException();
        }
        if (a.length > 64) {
            throw new IllegalStateException();
        }
        long num = 0L;
        for (int i = 1; i < a.length; ++i) {
            if (a[i] != '1') continue;
            num += (long)(1 << a.length - 1 - i);
        }
        return a[0] == '1' ? -num : num;
    }

    protected static abstract class Node {
        public boolean leaf;
        public Node[] next;

        protected Node(int r) {
            this.next = new Node[r];
        }

        public final <T extends Node> T next(int i) {
            return (T)this.next[i];
        }
    }
}

