/*
 * Decompiled with CFR 0.152.
 */
package shz.st.tst;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Predicate;
import shz.queue.CArrayQueue;
import shz.queue.LLinkedQueue;

public abstract class TST {
    protected Node root;

    protected TST() {
    }

    protected final <T extends Node> T root() {
        return (T)this.root;
    }

    protected final <T extends Node> T get(Node x, char[] a, int d, int n) {
        if (x == null) {
            return null;
        }
        if (a[d] < x.c) {
            return this.get(x.left, a, d, n);
        }
        if (a[d] > x.c) {
            return this.get(x.right, a, d, n);
        }
        if (d < n) {
            return this.get(x.mid, a, d + 1, n);
        }
        return (T)x;
    }

    protected final <T extends Node> T get(Node x, char[] a, int d) {
        return this.get(x, a, d, a.length - 1);
    }

    public final void delete(char[] a) {
        if (a == null) {
            throw new NullPointerException();
        }
        Object p = this.get(this.root, a, 0, a.length - 2);
        if (p == null) {
            return;
        }
        if (((Node)p).left != null && ((Node)p).left.c == a[a.length - 1]) {
            ((Node)p).left.leaf = false;
            if (((Node)p).left.left == null && ((Node)p).left.mid == null && ((Node)p).left.right == null) {
                ((Node)p).left = null;
            }
        } else if (((Node)p).mid != null && ((Node)p).mid.c == a[a.length - 1]) {
            ((Node)p).mid.leaf = false;
            if (((Node)p).mid.left == null && ((Node)p).mid.mid == null && ((Node)p).mid.right == null) {
                ((Node)p).mid = null;
            }
        } else if (((Node)p).right != null && ((Node)p).right.c == a[a.length - 1]) {
            ((Node)p).right.leaf = false;
            if (((Node)p).right.left == null && ((Node)p).right.mid == null && ((Node)p).right.right == null) {
                ((Node)p).right = null;
            }
        }
    }

    protected final Iterable<char[]> getChars0(Predicate<Node> predicate, int limit) {
        LLinkedQueue<char[]> result = LLinkedQueue.of();
        CArrayQueue key = CArrayQueue.of(16);
        this.getChars0(result, key, this.root, predicate, limit);
        return result.isEmpty() ? Collections.emptyList() : result;
    }

    private void getChars0(LLinkedQueue<char[]> result, CArrayQueue key, Node x, Predicate<Node> predicate, int limit) {
        if (x == null || limit > 0 && result.size() >= limit) {
            return;
        }
        if (x.leaf && predicate.test(x)) {
            char[] chars = new char[key.size() + 1];
            Iterator it = key.iterator();
            int i = 0;
            while (it.hasNext()) {
                chars[i++] = ((Character)it.next()).charValue();
            }
            chars[i] = x.c;
            result.offer(chars);
        }
        if (x.left != null) {
            this.getChars0(result, key, x.left, predicate, limit);
        }
        if (x.mid != null) {
            key.offer(x.c);
            this.getChars0(result, key, x.mid, predicate, limit);
            key.removeTail();
        }
        if (x.right != null) {
            this.getChars0(result, key, x.right, predicate, limit);
        }
    }

    protected static abstract class Node {
        public char c;
        public Node left;
        public Node mid;
        public Node right;
        public boolean leaf;

        protected Node(char c) {
            this.c = c;
        }

        public final <T extends Node> T left() {
            return (T)this.left;
        }

        public final <T extends Node> T mid() {
            return (T)this.mid;
        }

        public final <T extends Node> T right() {
            return (T)this.right;
        }
    }
}

