/*
 * Decompiled with CFR 0.152.
 */
package shz.stack;

import java.util.Iterator;

public abstract class ArrayStack<E>
implements Iterable<E> {
    protected static final int DEFAULT_CAPACITY = 8;
    protected int capacity;
    protected int size;

    protected ArrayStack(int capacity) {
        if (capacity < 1) {
            throw new IllegalArgumentException();
        }
        this.capacity = capacity;
    }

    protected abstract E get(int var1);

    @Override
    public Iterator<E> iterator() {
        return new ArrayStackIterator();
    }

    public final int size() {
        return this.size;
    }

    public final boolean isEmpty() {
        return this.size == 0;
    }

    protected final void beforePush() {
        if (this.size == this.capacity) {
            if (this.size == Integer.MAX_VALUE) {
                throw new OutOfMemoryError();
            }
            int newCap = this.capacity >= 64 ? this.capacity + (this.capacity >> 1) : this.capacity << 1;
            this.resize(newCap < 0 ? Integer.MAX_VALUE : newCap);
        }
    }

    protected abstract void resize(int var1);

    protected final void afterPop() {
        this.setNull(this.size);
        this.reduce();
    }

    private void reduce() {
        if (this.capacity > 64) {
            int newCap = this.size + 1 + (this.size + 1 >> 1);
            if (newCap + (newCap >> 1) <= this.capacity) {
                this.resize(newCap);
            }
        } else if (this.size + 1 <= this.capacity >>> 2) {
            this.resize(this.capacity >> 1);
        }
    }

    protected abstract void setNull(int var1);

    public final class ArrayStackIterator
    implements Iterator<E> {
        private int current;

        public ArrayStackIterator() {
            this.current = ArrayStack.this.size;
        }

        @Override
        public boolean hasNext() {
            return this.current > 0;
        }

        @Override
        public E next() {
            return ArrayStack.this.get(--this.current);
        }
    }
}

