/*
 * Decompiled with CFR 0.152.
 */
package shz.third;

import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import shz.AccessibleHelp;
import shz.HttpHelp;
import shz.IOHelp;
import shz.PRException;
import shz.ToMap;
import shz.ToObject;
import shz.Validator;
import shz.msg.ServerFailureMsg;
import shz.third.ApiConfig;
import shz.third.ApiIgnore;
import shz.third.ApiRequest;
import shz.third.ApiRequestConfig;
import shz.third.ApiResponse;
import shz.third.ApiValue;
import shz.tuple.Tuple2;

public abstract class AbstractApiRequest<D, T extends ApiResponse>
implements ApiRequest<D, T> {
    @ApiIgnore
    protected final Class<T> tCls = AccessibleHelp.getParameterizedType(this.getClass(), AbstractApiRequest.class, "T");
    @ApiIgnore
    protected final ApiRequestConfig config = this.getConfig();
    @ApiIgnore
    protected final Map<String, String> headers = new HashMap<String, String>();

    protected AbstractApiRequest() {
    }

    protected ApiRequestConfig getConfig() {
        Class<?> cls = this.getClass();
        ApiConfig apiConfig = cls.getAnnotation(ApiConfig.class);
        ServerFailureMsg.requireNon(apiConfig == null, "API\u8bf7\u6c42\u7c7b:%s\u7f3a\u5c11ApiConfig\u6ce8\u89e3", cls.getTypeName());
        ApiRequestConfig config = new ApiRequestConfig();
        config.url = apiConfig.url();
        config.method = apiConfig.method();
        config.proxyHost = apiConfig.proxyHost();
        config.proxyPort = apiConfig.proxyPort();
        config.connectTimeoutMills = apiConfig.connectTimeoutMills();
        config.readTimeoutMills = apiConfig.readTimeoutMills();
        return config;
    }

    @Override
    public final T execute(D data) {
        Map<String, Object> dataMap = this.dataMap();
        this.init(data, dataMap);
        String url = this.url(dataMap);
        String body = this.body(dataMap);
        this.before(url, body);
        try {
            String response = this.read(HttpHelp.requestIs(url, this::sslContext, this.headers, this.config.method, body == null ? null : body.getBytes(this.charset()), this.config.proxyHost, Integer.parseInt(this.config.proxyPort), Integer.parseInt(this.config.connectTimeoutMills), Integer.parseInt(this.config.readTimeoutMills)));
            this.after(url, body, response);
            return this.analysis(response);
        }
        catch (Exception e) {
            throw PRException.of(e);
        }
    }

    private Map<String, Object> dataMap() {
        List<Field> fields = AccessibleHelp.fields(this.getClass(), f -> !this.ignoreField((Field)f));
        if (fields.isEmpty()) {
            return Collections.emptyMap();
        }
        Map dataMap = (Map)ToMap.get(fields.size()).build();
        for (Field field : fields) {
            try {
                Tuple2<Boolean, Object> value;
                Tuple2<Boolean, String> key;
                ApiValue apiValue;
                String name = field.getName();
                Object obj = field.get(this);
                if (obj == null && (apiValue = field.getAnnotation(ApiValue.class)) != null) {
                    obj = ToObject.parse(this.apiValue(apiValue.value()), field.getType());
                }
                if ((key = this.nameFilter(name, obj)) == null || Validator.isTrue(key._1) || (value = this.valueFilter(name, obj)) == null || Validator.isTrue(value._1)) continue;
                dataMap.put(key._2, value._2);
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
        return dataMap.isEmpty() ? Collections.emptyMap() : dataMap;
    }

    protected boolean ignoreField(Field field) {
        return field.isAnnotationPresent(ApiIgnore.class);
    }

    protected String apiValue(String value) {
        return value;
    }

    protected Tuple2<Boolean, String> nameFilter(String name, Object value) {
        return Tuple2.apply(Boolean.FALSE, name);
    }

    protected Tuple2<Boolean, Object> valueFilter(String name, Object value) {
        return Tuple2.apply(value == null, value);
    }

    protected void init(D data, Map<String, Object> dataMap) {
    }

    protected String url(Map<String, Object> dataMap) {
        return this.config.url;
    }

    protected SSLContext sslContext() {
        return null;
    }

    protected String body(Map<String, Object> dataMap) {
        return null;
    }

    protected Charset charset() {
        return StandardCharsets.UTF_8;
    }

    protected void before(String url, String body) {
    }

    protected String read(InputStream is) {
        return IOHelp.read(IOHelp.getBr(is, this.charset()));
    }

    protected void after(String url, String body, String response) {
    }

    protected abstract T analysis(String var1);
}

