/*
 * Decompiled with CFR 0.152.
 */
package shz.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import shz.PRException;
import shz.ToMap;
import shz.ToObject;
import shz.ToSet;
import shz.Validator;

public final class W3cXmlHelp {
    private static final String NAME_SEPARATOR = "--";
    private static final String NUM_SEPARATOR = "N";
    private static final W3cXmlSetFieldStrategy STRATEGY = new W3cXmlSetFieldStrategy();

    private W3cXmlHelp() {
        throw new IllegalStateException();
    }

    public static Document getXmlDocument(InputSource in) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            return db.parse(in);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw PRException.of(e);
        }
    }

    public static Document getXmlDocument(String uri) {
        return W3cXmlHelp.getXmlDocument(new InputSource(uri));
    }

    public static Document getXmlDocument(File file) {
        return W3cXmlHelp.getXmlDocument(new InputSource(file.toURI().toASCIIString()));
    }

    public static Document getXmlDocument(InputStream is, String systemId) {
        InputSource in = new InputSource(is);
        in.setSystemId(systemId);
        return W3cXmlHelp.getXmlDocument(in);
    }

    public static Document getXmlDocument(InputStream is) {
        return W3cXmlHelp.getXmlDocument(new InputSource(is));
    }

    public static Document getXmlDocument(Reader reader) {
        return W3cXmlHelp.getXmlDocument(new InputSource(reader));
    }

    public static Node getXmlNode(Document document) {
        return document.getDocumentElement();
    }

    public static Map<String, Node> getNodeChildNodes(Node node) {
        NodeList nodelist = node.getChildNodes();
        if (nodelist.getLength() == 0) {
            return Collections.emptyMap();
        }
        Map map = (Map)ToMap.get(nodelist.getLength()).build();
        for (int i = 0; i < nodelist.getLength(); ++i) {
            map.put(W3cXmlHelp.getKeyNum(nodelist.item(i).getNodeName(), 0), nodelist.item(i));
        }
        return map.isEmpty() ? Collections.emptyMap() : map;
    }

    private static String getKeyNum(String k, int num) {
        int length;
        int indexOf = (k = k.trim()).indexOf(NUM_SEPARATOR, Math.max(length = k.length() - (NUM_SEPARATOR.length() << 1) - 3, 0));
        indexOf = indexOf < 0 ? k.length() : indexOf;
        return k.substring(0, indexOf) + NUM_SEPARATOR + num + NUM_SEPARATOR;
    }

    public static Map<String, Node> getNodeAllChildNodes(Map<String, Node> map, String k, Node v, boolean pc) {
        NodeList nodelist = v.getChildNodes();
        if (nodelist.getLength() != 0) {
            if (pc) {
                map.put(W3cXmlHelp.getKey(k, map, 0), v);
            }
            for (int i = 0; i < nodelist.getLength(); ++i) {
                W3cXmlHelp.getNodeAllChildNodes(map, W3cXmlHelp.getKey(k + NAME_SEPARATOR + nodelist.item(i).getNodeName(), map, 0), nodelist.item(i), pc);
            }
        } else {
            map.put(W3cXmlHelp.getKey(k, map, 0), v);
        }
        return map.isEmpty() ? Collections.emptyMap() : map;
    }

    public static Map<String, Node> getNodeAllChildNodes(Map<String, Node> map, String k, Node v) {
        return W3cXmlHelp.getNodeAllChildNodes(map, k, v, false);
    }

    private static String getKey(String k, Map<String, Node> map, int num) {
        String keyNum = W3cXmlHelp.getKeyNum(k, num);
        return map.containsKey(keyNum) ? W3cXmlHelp.getKey(k, map, num + 1) : keyNum;
    }

    public static Map<String, Node> getXmlMap(Document document, boolean pc) {
        HashMap map = new HashMap();
        W3cXmlHelp.getNodeChildNodes(W3cXmlHelp.getXmlNode(document)).forEach((k, v) -> W3cXmlHelp.getNodeAllChildNodes(map, k, v, pc));
        return map.isEmpty() ? Collections.emptyMap() : map;
    }

    public static Map<String, Node> getXmlMap(Document document) {
        return W3cXmlHelp.getXmlMap(document, false);
    }

    public static Map<String, Node> getXmlMap(String uri, boolean pc) {
        return W3cXmlHelp.getXmlMap(W3cXmlHelp.getXmlDocument(uri), pc);
    }

    public static Map<String, Node> getXmlMap(String uri) {
        return W3cXmlHelp.getXmlMap(W3cXmlHelp.getXmlDocument(uri));
    }

    public static Map<String, Node> getXmlMap(File file, boolean pc) {
        return W3cXmlHelp.getXmlMap(W3cXmlHelp.getXmlDocument(file), pc);
    }

    public static Map<String, Node> getXmlMap(File file) {
        return W3cXmlHelp.getXmlMap(W3cXmlHelp.getXmlDocument(file));
    }

    public static List<Node> getXmlNodes(Map<String, Node> map, String names) {
        LinkedList result = new LinkedList();
        String[] allNames = names.trim().split(" +");
        String name = allNames[allNames.length - 1];
        String[] parentNames = new String[allNames.length - 1];
        System.arraycopy(allNames, 0, parentNames, 0, parentNames.length);
        int[] index = new int[parentNames.length];
        map.forEach((k, v) -> {
            String p_s = k.trim().replaceAll("N\\d+N", "");
            if (p_s.endsWith(name)) {
                if (parentNames.length == 0) {
                    result.add(v);
                } else {
                    index[index.length - 1] = -1;
                    for (int i = 0; i < index.length && (index[i] = p_s.indexOf(parentNames[i])) != -1; ++i) {
                    }
                    if (index[index.length - 1] != -1 && W3cXmlHelp.isMinToMax(index, 0)) {
                        result.add(v);
                    }
                }
            }
        });
        return result.isEmpty() ? Collections.emptyList() : result;
    }

    private static boolean isMinToMax(int[] index, int n) {
        if (n + 1 < index.length) {
            if (index[n] < index[n + 1]) {
                return W3cXmlHelp.isMinToMax(index, n + 1);
            }
            return false;
        }
        return true;
    }

    public static List<Node> getXmlNodes(String xml, boolean pc, String name) {
        return W3cXmlHelp.getXmlNodes(W3cXmlHelp.getXmlMap(xml, pc), name);
    }

    public static <T> T toObject(Class<? extends T> cls, String uri) {
        return (T)((W3cXmlSetFieldStrategy)STRATEGY.clone()).fromMap(cls, W3cXmlHelp.getXmlMap(uri, true));
    }

    public static <T> T toObject(T t, String uri) {
        return ((W3cXmlSetFieldStrategy)STRATEGY.clone()).fromMap(t, W3cXmlHelp.getXmlMap(uri, true));
    }

    public static <T> T toObject(Class<T> cls, File file) {
        return (T)((W3cXmlSetFieldStrategy)STRATEGY.clone()).fromMap(cls, W3cXmlHelp.getXmlMap(file, true));
    }

    public static <T> T toObject(T t, File file) {
        return ((W3cXmlSetFieldStrategy)STRATEGY.clone()).fromMap(t, W3cXmlHelp.getXmlMap(file, true));
    }

    public static String getValueFromXmlStrByKey(String xmlStr, String key) {
        if (Validator.isAnyBlank((Object)xmlStr, (Object)key)) {
            return null;
        }
        return ((Element)W3cXmlHelp.getXmlNode(W3cXmlHelp.getXmlDocument(new StringReader(xmlStr)))).getElementsByTagName(key).item(0).getTextContent();
    }

    public static Map<String, String> getValuesFromXmlStrByKeys(String xmlStr, String ... keys) {
        if (Validator.isBlank(xmlStr) || Validator.isEmpty(keys)) {
            return Collections.emptyMap();
        }
        Element element = (Element)W3cXmlHelp.getXmlNode(W3cXmlHelp.getXmlDocument(new StringReader(xmlStr)));
        return ToMap.explicitCollect(Arrays.stream(keys), Function.identity(), k -> element.getElementsByTagName((String)k).item(0).getTextContent(), keys.length);
    }

    static final class W3cXmlSetFieldStrategy
    extends ToObject.SetFieldStrategy {
        Map<String, Node> map;

        W3cXmlSetFieldStrategy() {
        }

        @Override
        public Function<Field, BiFunction<Function<Field, String>, Class<?>, Collection<?>>> supCollection() {
            return t -> (u, r) -> ToSet.collect(this.keys((Field)t).parallelStream().map(k -> this.executor((String)k, (Class<?>)r)));
        }

        @Override
        public Function<Field, BiFunction<Function<Field, String>, Class<?>[], Map<?, ?>>> supMap() {
            return t -> (u, r) -> ToMap.collect(this.keys((Field)t).parallelStream(), k -> this.executor((String)k, r[0]), k -> this.executor((String)k, r[1]));
        }

        @Override
        public Function<Field, BiFunction<Function<Field, String>, Class<?>, Object>> supObject() {
            return t -> (u, r) -> this.executor((String)u.apply(t), (Class<?>)r);
        }

        @Override
        protected Collection<String> keys(Field field) {
            String keyNum;
            ArrayList<String> keys = new ArrayList<String>(this.map.size());
            String key = field.getName();
            int num = 0;
            while (this.map.containsKey(keyNum = W3cXmlHelp.getKeyNum(key, num))) {
                keys.add(keyNum);
                ++num;
            }
            return keys;
        }

        @Override
        protected Object executor(String key, Class<?> cls) {
            return ToObject.fromMap(cls, this.map, f -> this.key(key + W3cXmlHelp.NAME_SEPARATOR + f.getName()), n -> n == null ? null : ((Node)n).getTextContent(), (ToObject.SetFieldStrategy)this);
        }

        private String key(String key) {
            String keyNum = W3cXmlHelp.getKeyNum(key, 0);
            return this.map.containsKey(keyNum) ? keyNum : null;
        }

        <T> T fromMap(Class<? extends T> cls, Map<String, Node> map) {
            this.map = map;
            return ToObject.fromMap(cls, map, f -> this.key(f.getName()), n -> n == null ? null : ((Node)n).getTextContent(), (ToObject.SetFieldStrategy)this);
        }

        <T> T fromMap(T t, Map<String, Node> map) {
            this.map = map;
            return ToObject.fromMap(t, map, f -> this.key(f.getName()), n -> n == null ? null : ((Node)n).getTextContent(), (ToObject.SetFieldStrategy)this);
        }
    }
}

