/*
 * Decompiled with CFR 0.152.
 */
package io.github.shiruka.nbt;

import io.github.shiruka.nbt.PrimitiveTag;
import org.jetbrains.annotations.NotNull;

public interface ArrayTag<T>
extends PrimitiveTag<T[]> {
    public static void checkIndex(int index, int length) {
        if (index < 0 || index >= length) {
            String desc = String.format("Index out of bounds: %s", index);
            if (index < 0) {
                throw new IndexOutOfBoundsException(String.format("%s (%s) must not be negative", desc, index));
            }
            if (length < 0) {
                throw new IllegalArgumentException("negative size: " + length);
            }
            throw new IndexOutOfBoundsException(String.format("%s (%s) must be less than size (%s)", desc, index, length));
        }
    }

    @Override
    @NotNull
    default public ArrayTag<?> asArray() {
        return this;
    }

    @Override
    default public boolean isArray() {
        return true;
    }

    @NotNull
    public T get(int var1);

    public int size();
}

