/*
 * Decompiled with CFR 0.152.
 */
package io.github.shiruka.nbt;

import io.github.shiruka.nbt.CompoundTag;
import io.github.shiruka.nbt.ListTag;
import io.github.shiruka.nbt.PrimitiveTag;
import io.github.shiruka.nbt.Tag;
import io.github.shiruka.nbt.TagTypes;
import io.github.shiruka.nbt.array.ByteArrayTag;
import io.github.shiruka.nbt.array.IntArrayTag;
import io.github.shiruka.nbt.array.LongArrayTag;
import io.github.shiruka.nbt.misc.OptionalByte;
import io.github.shiruka.nbt.misc.OptionalFloat;
import io.github.shiruka.nbt.misc.OptionalShort;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import org.jetbrains.annotations.NotNull;

public interface ContainerTag<K, S extends ContainerTag<K, S>>
extends Tag {
    public boolean contains(@NotNull Tag var1);

    public boolean containsKey(@NotNull K var1);

    @NotNull
    public Optional<Tag> get(@NotNull K var1);

    @NotNull
    default public OptionalByte getByte(@NotNull K key) {
        return this.get(key).filter(Tag::isByte).map(Tag::asByte).map(tag -> OptionalByte.of(tag.byteValue())).orElseGet(OptionalByte::empty);
    }

    @NotNull
    default public Optional<byte[]> getByteArray(@NotNull K key) {
        return this.get(key).filter(Tag::isByteArray).map(Tag::asByteArray).map(ByteArrayTag::primitiveValue);
    }

    @NotNull
    default public Optional<CompoundTag> getCompoundTag(@NotNull K key) {
        return this.get(key).filter(Tag::isCompound).map(Tag::asCompound);
    }

    @NotNull
    default public OptionalDouble getDouble(@NotNull K key) {
        return this.get(key).filter(Tag::isDouble).map(Tag::asDouble).map(doubleTag -> OptionalDouble.of(doubleTag.doubleValue())).orElseGet(OptionalDouble::empty);
    }

    @NotNull
    default public OptionalFloat getFloat(@NotNull K key) {
        return this.get(key).filter(Tag::isFloat).map(Tag::asFloat).map(doubleTag -> OptionalFloat.of(doubleTag.floatValue())).orElseGet(OptionalFloat::empty);
    }

    @NotNull
    default public Optional<int[]> getIntArray(@NotNull K key) {
        return this.get(key).filter(Tag::isIntArray).map(Tag::asIntArray).map(IntArrayTag::primitiveValue);
    }

    @NotNull
    default public OptionalInt getInteger(@NotNull K key) {
        return this.get(key).filter(Tag::isInt).map(Tag::asInt).map(intTag -> OptionalInt.of(intTag.intValue())).orElseGet(OptionalInt::empty);
    }

    @NotNull
    default public Optional<List<Tag>> getList(@NotNull K key) {
        return this.getListTag(key).map(ListTag::all);
    }

    @NotNull
    default public Optional<List<Tag>> getList(@NotNull K key, @NotNull TagTypes listType) {
        return this.getListTag(key, listType).map(ListTag::all);
    }

    @NotNull
    default public Optional<ListTag> getListTag(@NotNull K key) {
        return this.get(key).filter(Tag::isList).map(Tag::asList);
    }

    @NotNull
    default public Optional<ListTag> getListTag(@NotNull K key, @NotNull TagTypes listType) {
        return this.get(key).filter(Tag::isList).map(Tag::asList).filter(tags -> tags.getListType() == listType);
    }

    @NotNull
    default public OptionalLong getLong(@NotNull K key) {
        return this.get(key).filter(Tag::isLong).map(Tag::asLong).map(longTag -> OptionalLong.of(longTag.longValue())).orElseGet(OptionalLong::empty);
    }

    @NotNull
    default public Optional<long[]> getLongArray(@NotNull K key) {
        return this.get(key).filter(Tag::isLongArray).map(Tag::asLongArray).map(LongArrayTag::primitiveValue);
    }

    @NotNull
    default public Optional<Map<String, Tag>> getMap(@NotNull K key) {
        return this.getCompoundTag(key).map(CompoundTag::all);
    }

    @NotNull
    default public OptionalShort getShort(@NotNull K key) {
        return this.get(key).filter(Tag::isShort).map(Tag::asShort).map(shortTag -> OptionalShort.of(shortTag.shortValue())).orElseGet(OptionalShort::empty);
    }

    @NotNull
    default public Optional<String> getString(@NotNull K key) {
        return this.get(key).filter(Tag::isString).map(Tag::asString).map(PrimitiveTag::value);
    }

    public boolean isEmpty();

    @NotNull
    public S remove(@NotNull K var1);

    @NotNull
    public S set(@NotNull K var1, @NotNull Tag var2);

    @NotNull
    default public S setByte(@NotNull K key, byte value) {
        return this.set(key, Tag.createByte(value));
    }

    @NotNull
    default public S setByteArray(@NotNull K key, byte ... value) {
        return this.set(key, Tag.createByteArray(value));
    }

    @NotNull
    default public S setDouble(@NotNull K key, double value) {
        return this.set(key, Tag.createDouble(value));
    }

    @NotNull
    default public S setFloat(@NotNull K key, float value) {
        return this.set(key, Tag.createFloat(value));
    }

    @NotNull
    default public S setIntArray(@NotNull K key, int ... value) {
        return this.set(key, Tag.createIntArray(value));
    }

    @NotNull
    default public S setInteger(@NotNull K key, int value) {
        return this.set(key, Tag.createInt(value));
    }

    @NotNull
    default public S setList(@NotNull K key, @NotNull List<Tag> value) {
        return this.set(key, Tag.createList(value));
    }

    @NotNull
    default public S setLong(@NotNull K key, long value) {
        return this.set(key, Tag.createLong(value));
    }

    @NotNull
    default public S setLongArray(@NotNull K key, long @NotNull [] value) {
        return this.set(key, Tag.createLongArray(value));
    }

    @NotNull
    default public S setMap(@NotNull K key, @NotNull Map<String, Tag> value) {
        return this.set(key, Tag.createCompound(value));
    }

    @NotNull
    default public S setShort(@NotNull K key, short value) {
        return this.set(key, Tag.createShort(value));
    }

    @NotNull
    default public S setString(@NotNull K key, @NotNull String value) {
        return this.set(key, Tag.createString(value));
    }

    public int size();
}

