/*
 * Decompiled with CFR 0.152.
 */
package io.github.shiruka.nbt;

import io.github.shiruka.nbt.ArrayTag;
import io.github.shiruka.nbt.CompoundTag;
import io.github.shiruka.nbt.ListTag;
import io.github.shiruka.nbt.NumberTag;
import io.github.shiruka.nbt.PrimitiveTag;
import io.github.shiruka.nbt.TagTypes;
import io.github.shiruka.nbt.array.ByteArrayTag;
import io.github.shiruka.nbt.array.IntArrayTag;
import io.github.shiruka.nbt.array.LongArrayTag;
import io.github.shiruka.nbt.compound.CompoundTagBasic;
import io.github.shiruka.nbt.list.ListTagBasic;
import io.github.shiruka.nbt.primitive.ByteTag;
import io.github.shiruka.nbt.primitive.DoubleTag;
import io.github.shiruka.nbt.primitive.EndTag;
import io.github.shiruka.nbt.primitive.FloatTag;
import io.github.shiruka.nbt.primitive.IntTag;
import io.github.shiruka.nbt.primitive.LongTag;
import io.github.shiruka.nbt.primitive.ShortTag;
import io.github.shiruka.nbt.primitive.StringTag;
import io.github.shiruka.nbt.stream.LittleEndianByteBufInputStream;
import io.github.shiruka.nbt.stream.LittleEndianByteBufOutputStream;
import io.github.shiruka.nbt.stream.LittleEndianDataInputStream;
import io.github.shiruka.nbt.stream.LittleEndianDataOutputStream;
import io.github.shiruka.nbt.stream.NBTInputStream;
import io.github.shiruka.nbt.stream.NBTOutputStream;
import io.github.shiruka.nbt.stream.NetworkDataInputStream;
import io.github.shiruka.nbt.stream.NetworkDataOutputStream;
import io.netty.buffer.ByteBuf;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.jetbrains.annotations.NotNull;

public interface Tag {
    @NotNull
    public static ByteTag createByte() {
        return Tag.createByte(0);
    }

    @NotNull
    public static ByteTag createByte(int original) {
        return Tag.createByte((byte)original);
    }

    @NotNull
    public static ByteTag createByte(byte original) {
        return new ByteTag(original);
    }

    @NotNull
    public static ByteArrayTag createByteArray(byte ... original) {
        return new ByteArrayTag(original);
    }

    @NotNull
    public static CompoundTag createCompound() {
        return new CompoundTagBasic();
    }

    @NotNull
    public static CompoundTag createCompound(@NotNull Map<String, Tag> original) {
        return new CompoundTagBasic(original);
    }

    @NotNull
    public static DoubleTag createDouble() {
        return Tag.createDouble(0.0);
    }

    @NotNull
    public static DoubleTag createDouble(double original) {
        return new DoubleTag(original);
    }

    @NotNull
    public static EndTag createEnd() {
        return new EndTag();
    }

    @NotNull
    public static FloatTag createFloat() {
        return Tag.createFloat(0.0f);
    }

    @NotNull
    public static FloatTag createFloat(float original) {
        return new FloatTag(original);
    }

    @NotNull
    public static NBTInputStream createGZIPReader(@NotNull InputStream stream) throws IOException {
        return Tag.createReader(new GZIPInputStream(stream));
    }

    @NotNull
    public static NBTOutputStream createGZIPWriter(@NotNull OutputStream stream) throws IOException {
        return Tag.createWriter(new GZIPOutputStream(stream));
    }

    @NotNull
    public static IntTag createInt() {
        return Tag.createInt(0);
    }

    @NotNull
    public static IntTag createInt(int original) {
        return new IntTag(original);
    }

    @NotNull
    public static IntArrayTag createIntArray(int ... original) {
        return new IntArrayTag(original);
    }

    @NotNull
    public static ListTag createList(Tag ... original) {
        return Tag.createList(Arrays.asList(original));
    }

    @NotNull
    public static ListTag createList(@NotNull List<Tag> original) {
        return new ListTagBasic(original, original.stream().map(Tag::getType).findFirst().orElse(TagTypes.END));
    }

    @NotNull
    public static LongTag createLong() {
        return Tag.createLong(0L);
    }

    @NotNull
    public static LongTag createLong(long original) {
        return new LongTag(original);
    }

    @NotNull
    public static LongArrayTag createLongArray(long ... original) {
        return new LongArrayTag(original);
    }

    @NotNull
    public static NBTInputStream createNetworkReader(@NotNull InputStream stream) {
        return new NBTInputStream(new NetworkDataInputStream(stream));
    }

    @NotNull
    public static NBTOutputStream createNetworkWriter(@NotNull OutputStream stream) {
        return new NBTOutputStream(new NetworkDataOutputStream(stream));
    }

    @NotNull
    public static NumberTag createNumber(@NotNull Number original) {
        if (original instanceof Byte) {
            return new ByteTag(original.byteValue());
        }
        if (original instanceof Short) {
            return new ShortTag(original.shortValue());
        }
        if (original instanceof Integer) {
            return new IntTag(original.intValue());
        }
        if (original instanceof Long) {
            return new LongTag(original.longValue());
        }
        if (original instanceof Float) {
            return new FloatTag(original.floatValue());
        }
        return new DoubleTag(original.doubleValue());
    }

    @NotNull
    public static NBTInputStream createReader(@NotNull InputStream stream) {
        return new NBTInputStream(new DataInputStream(stream));
    }

    @NotNull
    public static NBTInputStream createReaderLE(@NotNull InputStream stream) {
        return new NBTInputStream(new LittleEndianDataInputStream(stream));
    }

    @NotNull
    public static NBTInputStream createReaderLE(@NotNull ByteBuf buffer) {
        return new NBTInputStream((DataInput)((Object)new LittleEndianByteBufInputStream(buffer)));
    }

    @NotNull
    public static ShortTag createShort() {
        return Tag.createShort(0);
    }

    @NotNull
    public static ShortTag createShort(int original) {
        return Tag.createShort((short)original);
    }

    @NotNull
    public static ShortTag createShort(short original) {
        return new ShortTag(original);
    }

    @NotNull
    public static StringTag createString(@NotNull String original) {
        return new StringTag(original);
    }

    @NotNull
    public static StringTag createString() {
        return Tag.createString("");
    }

    @NotNull
    public static NBTOutputStream createWriter(@NotNull OutputStream stream) {
        return new NBTOutputStream(new DataOutputStream(stream));
    }

    @NotNull
    public static NBTOutputStream createWriterLE(@NotNull OutputStream stream) {
        return new NBTOutputStream(new LittleEndianDataOutputStream(stream));
    }

    @NotNull
    public static NBTOutputStream createWriterLE(@NotNull ByteBuf buffer) {
        return new NBTOutputStream((DataOutput)((Object)new LittleEndianByteBufOutputStream(buffer)));
    }

    @NotNull
    default public ArrayTag<?> asArray() {
        throw new IllegalStateException(String.format("%s cannot cast as a ArrayTag!", this.getClass()));
    }

    @NotNull
    default public ByteTag asByte() {
        throw new IllegalStateException(String.format("%s cannot cast as a ByteTag!", this.getClass()));
    }

    @NotNull
    default public ByteArrayTag asByteArray() {
        throw new IllegalStateException(String.format("%s cannot cast as a ByteArrayTag!", this.getClass()));
    }

    @NotNull
    default public CompoundTag asCompound() {
        throw new IllegalStateException(String.format("%s cannot cast as a CompoundTag!", this.getClass()));
    }

    @NotNull
    default public DoubleTag asDouble() {
        throw new IllegalStateException(String.format("%s cannot cast as a DoubleTag!", this.getClass()));
    }

    @NotNull
    default public FloatTag asFloat() {
        throw new IllegalStateException(String.format("%s cannot cast as a FloatTag!", this.getClass()));
    }

    @NotNull
    default public IntTag asInt() {
        throw new IllegalStateException(String.format("%s cannot cast as a IntTag!", this.getClass()));
    }

    @NotNull
    default public IntArrayTag asIntArray() {
        throw new IllegalStateException(String.format("%s cannot cast as a IntArrayTag!", this.getClass()));
    }

    @NotNull
    default public ListTag asList() {
        throw new IllegalStateException(String.format("%s cannot cast as a ListTag!", this.getClass()));
    }

    @NotNull
    default public LongTag asLong() {
        throw new IllegalStateException(String.format("%s cannot cast as a LongTag!", this.getClass()));
    }

    @NotNull
    default public LongArrayTag asLongArray() {
        throw new IllegalStateException(String.format("%s cannot cast as a LongArrayTag!", this.getClass()));
    }

    @NotNull
    default public NumberTag asNumber() {
        throw new IllegalStateException(String.format("%s cannot cast as a NumberTag!", this.getClass()));
    }

    @NotNull
    default public PrimitiveTag<?> asPrimitive() {
        throw new IllegalStateException(String.format("%s cannot cast as a PrimitiveTag!", this.getClass()));
    }

    @NotNull
    default public ShortTag asShort() {
        throw new IllegalStateException(String.format("%s cannot cast as a ShortTag!", this.getClass()));
    }

    @NotNull
    default public StringTag asString() {
        throw new IllegalStateException(String.format("%s cannot cast as a StringTag!", this.getClass()));
    }

    @NotNull
    public TagTypes getType();

    default public boolean isArray() {
        return false;
    }

    default public boolean isByte() {
        return false;
    }

    default public boolean isByteArray() {
        return false;
    }

    default public boolean isCompound() {
        return false;
    }

    default public boolean isDouble() {
        return false;
    }

    default public boolean isFloat() {
        return false;
    }

    default public boolean isInt() {
        return false;
    }

    default public boolean isIntArray() {
        return false;
    }

    default public boolean isList() {
        return false;
    }

    default public boolean isLong() {
        return false;
    }

    default public boolean isLongArray() {
        return false;
    }

    default public boolean isNumber() {
        return false;
    }

    default public boolean isPrimitive() {
        return false;
    }

    default public boolean isShort() {
        return false;
    }

    default public boolean isString() {
        return false;
    }
}

