/*
 * Decompiled with CFR 0.152.
 */
package io.github.shiruka.nbt;

import io.github.shiruka.nbt.Tag;
import io.github.shiruka.nbt.primitive.EndTag;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum TagTypes {
    NONE(() -> null, -1),
    END(EndTag::new, 0),
    BYTE(Tag::createByte, 1),
    SHORT(Tag::createShort, 2),
    INT(Tag::createInt, 3),
    LONG(Tag::createLong, 4),
    FLOAT(Tag::createFloat, 5),
    DOUBLE(Tag::createDouble, 6),
    BYTE_ARRAY(() -> Tag.createByteArray(new byte[0]), 7),
    STRING(Tag::createString, 8),
    LIST(() -> Tag.createList(new Tag[0]), 9),
    COMPOUND(Tag::createCompound, 10),
    INT_ARRAY(() -> Tag.createIntArray(new int[0]), 11),
    LONG_ARRAY(() -> Tag.createLongArray(new long[0]), 12),
    ALL(() -> null, 99);

    private final @NotNull Supplier<@Nullable Tag> emptyTagSupplier;
    private final byte id;

    private TagTypes(Supplier<Tag> emptyTagSupplier, int id) {
        this(emptyTagSupplier, (byte)id);
    }

    @NotNull
    public Tag emptyTag() {
        return Objects.requireNonNull(this.emptyTagSupplier.get(), String.valueOf(this.id));
    }

    private TagTypes(Supplier<Tag> emptyTagSupplier, byte id) {
        if (emptyTagSupplier == null) {
            throw new NullPointerException("emptyTagSupplier is marked non-null but is null");
        }
        this.emptyTagSupplier = emptyTagSupplier;
        this.id = id;
    }

    public byte getId() {
        return this.id;
    }
}

