/*
 * Decompiled with CFR 0.152.
 */
package io.github.shiruka.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public final class VarInts {
    public static int readInt(@NotNull DataInput input) throws IOException {
        int n = (int)VarInts.decodeUnsigned(input);
        return n >>> 1 ^ -(n & 1);
    }

    public static long readLong(@NotNull DataInput input) throws IOException {
        long n = VarInts.decodeUnsigned(input);
        return n >>> 1 ^ -(n & 1L);
    }

    public static int readUnsignedInt(@NotNull DataInput input) throws IOException {
        return (int)VarInts.decodeUnsigned(input);
    }

    public static void writeInt(@NotNull DataOutput output, int integer) throws IOException {
        VarInts.encodeUnsigned(output, (long)integer << 1 ^ (long)(integer >> 31));
    }

    public static void writeLong(@NotNull DataOutput output, long longInteger) throws IOException {
        VarInts.encodeUnsigned(output, longInteger << 1 ^ longInteger >> 63);
    }

    public static void writeUnsignedInt(@NotNull DataOutput output, long integer) throws IOException {
        VarInts.encodeUnsigned(output, integer);
    }

    private static long decodeUnsigned(@NotNull DataInput input) throws IOException {
        long result = 0L;
        for (int shift = 0; shift < 64; shift += 7) {
            byte b = input.readByte();
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw new ArithmeticException("VarInt was too large");
    }

    private static void encodeUnsigned(@NotNull DataOutput output, long value) throws IOException {
        long tempValue = value;
        while (true) {
            if ((tempValue & 0xFFFFFFFFFFFFFF80L) == 0L) {
                output.writeByte((int)tempValue);
                return;
            }
            output.writeByte((byte)((int)tempValue & 0x7F | 0x80));
            tempValue >>>= 7;
        }
    }

    private VarInts() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

