/*
 * Decompiled with CFR 0.152.
 */
package io.github.shiruka.nbt.array;

import io.github.shiruka.nbt.ArrayTag;
import io.github.shiruka.nbt.TagTypes;
import io.github.shiruka.nbt.misc.ArrayUtils;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public final class ByteArrayTag
implements ArrayTag<Byte> {
    @NotNull
    private final Byte[] original;
    private final byte @NotNull [] primitiveOriginal;

    public ByteArrayTag(byte ... original) {
        this.primitiveOriginal = (byte[])original.clone();
        this.original = ArrayUtils.toObject(this.primitiveOriginal);
    }

    @Override
    @NotNull
    public ByteArrayTag asByteArray() {
        return this;
    }

    @Override
    @NotNull
    public TagTypes getType() {
        return TagTypes.BYTE_ARRAY;
    }

    @Override
    public boolean isByteArray() {
        return true;
    }

    @Override
    @NotNull
    public Byte get(int index) {
        ArrayTag.checkIndex(index, this.original.length);
        return this.original[index];
    }

    @Override
    public int size() {
        return this.original.length;
    }

    public int hashCode() {
        return Arrays.hashCode(this.primitiveOriginal);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ByteArrayTag that = (ByteArrayTag)o;
        return Arrays.equals(this.primitiveOriginal, that.primitiveOriginal);
    }

    public String toString() {
        return "ByteArrayTag{primitiveOriginal=" + Arrays.toString(this.primitiveOriginal) + '}';
    }

    public byte @NotNull [] primitiveValue() {
        return this.primitiveOriginal;
    }

    @Override
    @NotNull
    public @NotNull Byte @NotNull [] value() {
        return (Byte[])this.original.clone();
    }
}

