/*
 * Decompiled with CFR 0.152.
 */
package io.github.shiruka.nbt.array;

import io.github.shiruka.nbt.ArrayTag;
import io.github.shiruka.nbt.TagTypes;
import io.github.shiruka.nbt.misc.ArrayUtils;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public final class IntArrayTag
implements ArrayTag<Integer> {
    @NotNull
    private final @NotNull Integer @NotNull [] original;
    private final int @NotNull [] primitiveOriginal;

    public IntArrayTag(int ... original) {
        this.primitiveOriginal = (int[])original.clone();
        this.original = ArrayUtils.toObject(this.primitiveOriginal);
    }

    @Override
    @NotNull
    public IntArrayTag asIntArray() {
        return this;
    }

    @Override
    @NotNull
    public TagTypes getType() {
        return TagTypes.INT_ARRAY;
    }

    @Override
    public boolean isIntArray() {
        return true;
    }

    @Override
    @NotNull
    public Integer get(int index) {
        ArrayTag.checkIndex(index, this.original.length);
        return this.original[index];
    }

    @Override
    public int size() {
        return this.original.length;
    }

    public int hashCode() {
        return Arrays.hashCode(this.primitiveOriginal);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntArrayTag that = (IntArrayTag)o;
        return Arrays.equals(this.primitiveOriginal, that.primitiveOriginal);
    }

    public String toString() {
        return "IntArrayTag{primitiveOriginal=" + Arrays.toString(this.primitiveOriginal) + '}';
    }

    public int @NotNull [] primitiveValue() {
        return this.primitiveOriginal;
    }

    @Override
    @NotNull
    public @NotNull Integer @NotNull [] value() {
        return (Integer[])this.original.clone();
    }
}

