/*
 * Decompiled with CFR 0.152.
 */
package io.github.shiruka.nbt.array;

import io.github.shiruka.nbt.ArrayTag;
import io.github.shiruka.nbt.TagTypes;
import io.github.shiruka.nbt.misc.ArrayUtils;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public final class LongArrayTag
implements ArrayTag<Long> {
    @NotNull
    private final Long[] original;
    private final long @NotNull [] primitiveOriginal;

    public LongArrayTag(long ... original) {
        this.primitiveOriginal = (long[])original.clone();
        this.original = ArrayUtils.toObject(this.primitiveOriginal);
    }

    @Override
    @NotNull
    public LongArrayTag asLongArray() {
        return this;
    }

    @Override
    @NotNull
    public TagTypes getType() {
        return TagTypes.LONG_ARRAY;
    }

    @Override
    public boolean isLongArray() {
        return true;
    }

    @Override
    @NotNull
    public Long get(int index) {
        ArrayTag.checkIndex(index, this.original.length);
        return this.original[index];
    }

    @Override
    public int size() {
        return this.original.length;
    }

    public int hashCode() {
        return Arrays.hashCode(this.primitiveOriginal);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LongArrayTag that = (LongArrayTag)o;
        return Arrays.equals(this.primitiveOriginal, that.primitiveOriginal);
    }

    public String toString() {
        return "LongArrayTag{primitiveOriginal=" + Arrays.toString(this.primitiveOriginal) + '}';
    }

    public long @NotNull [] primitiveValue() {
        return this.primitiveOriginal;
    }

    @Override
    @NotNull
    public @NotNull Long @NotNull [] value() {
        return (Long[])this.original.clone();
    }
}

