/*
 * Decompiled with CFR 0.152.
 */
package io.github.shiruka.nbt.list;

import io.github.shiruka.nbt.ListTag;
import io.github.shiruka.nbt.Tag;
import io.github.shiruka.nbt.TagTypes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public final class ListTagBasic
implements ListTag {
    @NotNull
    private TagTypes listType;
    @NotNull
    private List<Tag> original;

    public ListTagBasic(@NotNull List<Tag> original, @NotNull TagTypes listType) {
        this.original = Collections.unmodifiableList(original);
        this.listType = listType;
    }

    @Override
    @NotNull
    public ListTag add(@NotNull Tag tag) {
        this.edit(tags -> {
            TagTypes endType = TagTypes.END;
            if (tag.getType() == endType) {
                throw new IllegalArgumentException(String.format("Cannot add a %s to a %s", new Object[]{endType, TagTypes.LIST}));
            }
            if (this.getListType() != endType && tag.getType() != this.listType) {
                throw new IllegalArgumentException(String.format("Trying to add tag of type %s to list of %s", new Object[]{tag.getType(), this.listType}));
            }
            tags.add(tag);
        }, tag.getType());
        return this;
    }

    @Override
    @NotNull
    public List<Tag> all() {
        return Collections.unmodifiableList(this.original);
    }

    @Override
    @NotNull
    public TagTypes getListType() {
        return this.listType;
    }

    @Override
    @NotNull
    public Stream<Tag> stream() {
        return this.original.stream();
    }

    @Override
    public boolean contains(@NotNull Tag o) {
        return this.original.contains(o);
    }

    @Override
    public boolean containsKey(@NotNull Integer key) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Optional<Tag> get(@NotNull Integer key) {
        return Optional.ofNullable(this.original.get(key));
    }

    @Override
    @NotNull
    public ListTag remove(@NotNull Integer key) {
        this.edit(tags -> tags.remove(key), TagTypes.NONE);
        return this;
    }

    @Override
    @NotNull
    public ListTag set(@NotNull Integer key, @NotNull Tag tag) {
        this.edit(tags -> tags.set(key, tag), tag.getType());
        return this;
    }

    @Override
    @NotNull
    public Iterator<Tag> iterator() {
        return this.original.iterator();
    }

    @Override
    public void forEach(@NotNull Consumer<? super Tag> action) {
        this.original.forEach(action);
    }

    @Override
    @NotNull
    public Spliterator<Tag> spliterator() {
        return Spliterators.spliterator(this.original, 1040);
    }

    private void edit(@NotNull Consumer<List<Tag>> consumer, @NotNull TagTypes type) {
        ArrayList<Tag> tags = new ArrayList<Tag>(this.original);
        consumer.accept(tags);
        if (type != TagTypes.NONE && this.listType == TagTypes.END) {
            this.original = tags;
            this.listType = type;
        } else {
            this.original = tags;
        }
    }

    public String toString() {
        return "ListTagBasic(original=" + this.original + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListTagBasic)) {
            return false;
        }
        ListTagBasic other = (ListTagBasic)o;
        List<Tag> this$original = this.original;
        List<Tag> other$original = other.original;
        return !(this$original == null ? other$original != null : !((Object)this$original).equals(other$original));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Tag> $original = this.original;
        result = result * 59 + ($original == null ? 43 : ((Object)$original).hashCode());
        return result;
    }
}

