/*
 * Decompiled with CFR 0.152.
 */
package io.github.shiruka.nbt.misc;

import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public final class ArrayUtils {
    private static final Byte[] EMPTY_BYTE_OBJECT_ARRAY = new Byte[0];
    private static final Integer[] EMPTY_INTEGER_OBJECT_ARRAY = new Integer[0];
    private static final Long[] EMPTY_LONG_OBJECT_ARRAY = new Long[0];

    @Contract(value="null -> null; !null -> !null")
    public static Byte @Nullable [] toObject(byte @Nullable [] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_BYTE_OBJECT_ARRAY;
        }
        Byte[] result = new Byte[array.length];
        for (int index = 0; index < array.length; ++index) {
            result[index] = array[index];
        }
        return result;
    }

    @Contract(value="null -> null; !null -> !null")
    public static Integer @Nullable [] toObject(int @Nullable [] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_INTEGER_OBJECT_ARRAY;
        }
        Integer[] result = new Integer[array.length];
        for (int index = 0; index < array.length; ++index) {
            result[index] = array[index];
        }
        return result;
    }

    @Contract(value="null -> null; !null -> !null")
    public static Long @Nullable [] toObject(long @Nullable [] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_LONG_OBJECT_ARRAY;
        }
        Long[] result = new Long[array.length];
        for (int index = 0; index < array.length; ++index) {
            result[index] = array[index];
        }
        return result;
    }

    private ArrayUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

