/*
 * Decompiled with CFR 0.152.
 */
package io.github.shiruka.nbt.misc;

import io.github.shiruka.nbt.misc.ByteConsumer;
import io.github.shiruka.nbt.misc.ByteSupplier;
import java.util.NoSuchElementException;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public final class OptionalByte {
    private static final OptionalByte EMPTY = new OptionalByte();
    private final boolean isPresent;
    private final byte value;

    private OptionalByte() {
        this.isPresent = false;
        this.value = 0;
    }

    private OptionalByte(byte value) {
        this.isPresent = true;
        this.value = value;
    }

    @NotNull
    public static OptionalByte empty() {
        return EMPTY;
    }

    @NotNull
    public static OptionalByte of(byte value) {
        return new OptionalByte(value);
    }

    public byte getAsByte() {
        if (!this.isPresent) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public int hashCode() {
        return this.isPresent ? Byte.hashCode(this.value) : 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OptionalByte that = (OptionalByte)o;
        if (this.isPresent != that.isPresent) {
            return false;
        }
        return this.value == that.value;
    }

    public String toString() {
        return this.isPresent ? String.format("OptionalByte[%s]", this.value) : "OptionalByte.empty";
    }

    public void ifPresent(ByteConsumer action) {
        if (this.isPresent) {
            action.accept(this.value);
        }
    }

    public void ifPresentOrElse(ByteConsumer action, Runnable emptyAction) {
        if (this.isPresent) {
            action.accept(this.value);
        } else {
            emptyAction.run();
        }
    }

    public boolean isEmpty() {
        return !this.isPresent;
    }

    public boolean isPresent() {
        return this.isPresent;
    }

    public byte orElse(byte other) {
        return this.isPresent ? this.value : other;
    }

    public byte orElseGet(ByteSupplier supplier) {
        return this.isPresent ? this.value : supplier.get();
    }

    public byte orElseThrow() {
        if (!this.isPresent) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public <X extends Throwable> byte orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (this.isPresent) {
            return this.value;
        }
        throw (Throwable)exceptionSupplier.get();
    }
}

