/*
 * Decompiled with CFR 0.152.
 */
package io.github.shiruka.nbt.misc;

import io.github.shiruka.nbt.misc.FloatConsumer;
import io.github.shiruka.nbt.misc.FloatSupplier;
import java.util.NoSuchElementException;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public final class OptionalFloat {
    private static final OptionalFloat EMPTY = new OptionalFloat();
    private final boolean isPresent;
    private final float value;

    private OptionalFloat() {
        this.isPresent = false;
        this.value = 0.0f;
    }

    private OptionalFloat(float value) {
        this.isPresent = true;
        this.value = value;
    }

    @NotNull
    public static OptionalFloat empty() {
        return EMPTY;
    }

    @NotNull
    public static OptionalFloat of(float value) {
        return new OptionalFloat(value);
    }

    public float getAsFloat() {
        if (!this.isPresent) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public int hashCode() {
        return this.isPresent ? Float.hashCode(this.value) : 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OptionalFloat that = (OptionalFloat)o;
        if (this.isPresent != that.isPresent) {
            return false;
        }
        return Float.compare(this.value, that.value) == 0;
    }

    public String toString() {
        return this.isPresent ? String.format("OptionalFloat[%s]", Float.valueOf(this.value)) : "OptionalFloat.empty";
    }

    public void ifPresent(FloatConsumer action) {
        if (this.isPresent) {
            action.accept(this.value);
        }
    }

    public void ifPresentOrElse(FloatConsumer action, Runnable emptyAction) {
        if (this.isPresent) {
            action.accept(this.value);
        } else {
            emptyAction.run();
        }
    }

    public boolean isEmpty() {
        return !this.isPresent;
    }

    public boolean isPresent() {
        return this.isPresent;
    }

    public float orElse(float other) {
        return this.isPresent ? this.value : other;
    }

    public float orElseGet(FloatSupplier supplier) {
        return this.isPresent ? this.value : supplier.get();
    }

    public float orElseThrow() {
        if (!this.isPresent) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public <X extends Throwable> float orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (this.isPresent) {
            return this.value;
        }
        throw (Throwable)exceptionSupplier.get();
    }
}

