/*
 * Decompiled with CFR 0.152.
 */
package io.github.shiruka.nbt.misc;

import io.github.shiruka.nbt.misc.ShortConsumer;
import io.github.shiruka.nbt.misc.ShortSupplier;
import java.util.NoSuchElementException;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public final class OptionalShort {
    private static final OptionalShort EMPTY = new OptionalShort();
    private final boolean isPresent;
    private final short value;

    private OptionalShort() {
        this.isPresent = false;
        this.value = 0;
    }

    private OptionalShort(short value) {
        this.isPresent = true;
        this.value = value;
    }

    @NotNull
    public static OptionalShort empty() {
        return EMPTY;
    }

    @NotNull
    public static OptionalShort of(short value) {
        return new OptionalShort(value);
    }

    public short getAsShort() {
        if (!this.isPresent) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public int hashCode() {
        return this.isPresent ? Short.hashCode(this.value) : 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OptionalShort that = (OptionalShort)o;
        if (this.isPresent != that.isPresent) {
            return false;
        }
        return this.value == that.value;
    }

    public String toString() {
        return this.isPresent ? String.format("OptionalShort[%s]", this.value) : "OptionalShort.empty";
    }

    public void ifPresent(ShortConsumer action) {
        if (this.isPresent) {
            action.accept(this.value);
        }
    }

    public void ifPresentOrElse(ShortConsumer action, Runnable emptyAction) {
        if (this.isPresent) {
            action.accept(this.value);
        } else {
            emptyAction.run();
        }
    }

    public boolean isEmpty() {
        return !this.isPresent;
    }

    public boolean isPresent() {
        return this.isPresent;
    }

    public short orElse(short other) {
        return this.isPresent ? this.value : other;
    }

    public short orElseGet(ShortSupplier supplier) {
        return this.isPresent ? this.value : supplier.get();
    }

    public short orElseThrow() {
        if (!this.isPresent) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public <X extends Throwable> short orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (this.isPresent) {
            return this.value;
        }
        throw (Throwable)exceptionSupplier.get();
    }
}

