/*
 * Decompiled with CFR 0.152.
 */
package io.github.shiruka.nbt.stream;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import org.jetbrains.annotations.NotNull;

public final class LittleEndianByteBufInputStream
extends ByteBufInputStream {
    @NotNull
    private final ByteBuf buffer;

    public LittleEndianByteBufInputStream(@NotNull ByteBuf buffer) {
        super(buffer);
        this.buffer = buffer;
    }

    public char readChar() {
        return Character.reverseBytes(this.buffer.readChar());
    }

    public double readDouble() {
        return this.buffer.readDoubleLE();
    }

    public float readFloat() {
        return this.buffer.readFloatLE();
    }

    public int readInt() {
        return this.buffer.readIntLE();
    }

    public long readLong() {
        return this.buffer.readLongLE();
    }

    public short readShort() {
        return this.buffer.readShortLE();
    }

    public int readUnsignedShort() {
        return this.buffer.readUnsignedShortLE();
    }
}

