/*
 * Decompiled with CFR 0.152.
 */
package io.github.shiruka.nbt.stream;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;

public final class LittleEndianByteBufOutputStream
extends ByteBufOutputStream {
    @NotNull
    private final ByteBuf buffer;

    public LittleEndianByteBufOutputStream(@NotNull ByteBuf buffer) {
        super(buffer);
        this.buffer = buffer;
    }

    public void writeChar(int v) {
        this.buffer.writeChar((int)Character.reverseBytes((char)v));
    }

    public void writeDouble(double v) {
        this.buffer.writeDoubleLE(v);
    }

    public void writeFloat(float v) {
        this.buffer.writeFloatLE(v);
    }

    public void writeInt(int v) {
        this.buffer.writeIntLE(v);
    }

    public void writeLong(long v) {
        this.buffer.writeLongLE(v);
    }

    public void writeShort(int v) {
        this.buffer.writeShortLE(v);
    }

    public void writeUTF(@NotNull String s) throws IOException {
        byte[] bytes = s.getBytes(StandardCharsets.UTF_8);
        this.writeShort(bytes.length);
        this.write(bytes);
    }
}

