/*
 * Decompiled with CFR 0.152.
 */
package io.github.shiruka.nbt.stream;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;

public class LittleEndianDataInputStream
implements DataInput,
Closeable {
    @NotNull
    protected final DataInputStream stream;

    public LittleEndianDataInputStream(@NotNull InputStream stream) {
        this.stream = new DataInputStream(stream);
    }

    public LittleEndianDataInputStream(@NotNull DataInputStream stream) {
        this.stream = stream;
    }

    @Override
    public final void close() throws IOException {
        this.stream.close();
    }

    @Override
    public final void readFully(byte @NotNull [] b) throws IOException {
        this.stream.readFully(b);
    }

    @Override
    public final void readFully(byte @NotNull [] b, int off, int len) throws IOException {
        this.stream.readFully(b, off, len);
    }

    @Override
    public final int skipBytes(int n) throws IOException {
        return this.stream.skipBytes(n);
    }

    @Override
    public final boolean readBoolean() throws IOException {
        return this.stream.readBoolean();
    }

    @Override
    public final byte readByte() throws IOException {
        return this.stream.readByte();
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        return this.stream.readUnsignedByte();
    }

    @Override
    public final short readShort() throws IOException {
        return Short.reverseBytes(this.stream.readShort());
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        return Short.toUnsignedInt(Short.reverseBytes(this.stream.readShort()));
    }

    @Override
    public final char readChar() throws IOException {
        return Character.reverseBytes(this.stream.readChar());
    }

    @Override
    public int readInt() throws IOException {
        return Integer.reverseBytes(this.stream.readInt());
    }

    @Override
    public long readLong() throws IOException {
        return Long.reverseBytes(this.stream.readLong());
    }

    @Override
    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(Integer.reverseBytes(this.stream.readInt()));
    }

    @Override
    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(Long.reverseBytes(this.stream.readLong()));
    }

    @Override
    @Deprecated
    public final String readLine() throws IOException {
        return this.stream.readLine();
    }

    @Override
    @NotNull
    public String readUTF() throws IOException {
        byte[] bytes = new byte[this.readUnsignedShort()];
        this.readFully(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }
}

