/*
 * Decompiled with CFR 0.152.
 */
package io.github.shiruka.nbt.stream;

import java.io.Closeable;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;

public class LittleEndianDataOutputStream
implements DataOutput,
Closeable {
    @NotNull
    protected final DataOutputStream stream;

    public LittleEndianDataOutputStream(@NotNull OutputStream stream) {
        this.stream = new DataOutputStream(stream);
    }

    public LittleEndianDataOutputStream(@NotNull DataOutputStream stream) {
        this.stream = stream;
    }

    @Override
    public final void close() throws IOException {
        this.stream.close();
    }

    @Override
    public final void write(int b) throws IOException {
        this.stream.write(b);
    }

    @Override
    public final void write(byte @NotNull [] b) throws IOException {
        this.stream.write(b);
    }

    @Override
    public final void write(byte @NotNull [] b, int off, int len) throws IOException {
        this.stream.write(b, off, len);
    }

    @Override
    public final void writeBoolean(boolean v) throws IOException {
        this.stream.writeBoolean(v);
    }

    @Override
    public final void writeByte(int v) throws IOException {
        this.stream.writeByte(v);
    }

    @Override
    public final void writeShort(int v) throws IOException {
        this.stream.writeShort(Short.reverseBytes((short)v));
    }

    @Override
    public final void writeChar(int v) throws IOException {
        this.stream.writeChar(Character.reverseBytes((char)v));
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.stream.writeInt(Integer.reverseBytes(v));
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.stream.writeLong(Long.reverseBytes(v));
    }

    @Override
    public final void writeFloat(float v) throws IOException {
        this.stream.writeInt(Integer.reverseBytes(Float.floatToIntBits(v)));
    }

    @Override
    public final void writeDouble(double v) throws IOException {
        this.stream.writeLong(Long.reverseBytes(Double.doubleToLongBits(v)));
    }

    @Override
    public final void writeBytes(@NotNull String s) throws IOException {
        this.stream.writeBytes(s);
    }

    @Override
    public final void writeChars(@NotNull String s) throws IOException {
        this.stream.writeChars(s);
    }

    @Override
    public void writeUTF(@NotNull String s) throws IOException {
        byte[] bytes = s.getBytes(StandardCharsets.UTF_8);
        this.writeShort(bytes.length);
        this.write(bytes);
    }
}

