/*
 * Decompiled with CFR 0.152.
 */
package io.github.shiruka.nbt.stream;

import io.github.shiruka.nbt.CompoundTag;
import io.github.shiruka.nbt.ListTag;
import io.github.shiruka.nbt.Tag;
import io.github.shiruka.nbt.TagTypes;
import io.github.shiruka.nbt.array.ByteArrayTag;
import io.github.shiruka.nbt.array.IntArrayTag;
import io.github.shiruka.nbt.array.LongArrayTag;
import io.github.shiruka.nbt.primitive.ByteTag;
import io.github.shiruka.nbt.primitive.DoubleTag;
import io.github.shiruka.nbt.primitive.FloatTag;
import io.github.shiruka.nbt.primitive.IntTag;
import io.github.shiruka.nbt.primitive.LongTag;
import io.github.shiruka.nbt.primitive.ShortTag;
import io.github.shiruka.nbt.primitive.StringTag;
import java.io.Closeable;
import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public final class NBTInputStream
implements Closeable {
    @NotNull
    private final DataInput input;
    private boolean closed = false;

    public NBTInputStream(@NotNull DataInput input) {
        this.input = input;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.input instanceof Closeable) {
            ((Closeable)((Object)this.input)).close();
        }
    }

    @NotNull
    public Tag read(byte id) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Trying to read from a closed reader!");
        }
        switch (id) {
            case 1: {
                return this.readByte();
            }
            case 2: {
                return this.readShort();
            }
            case 3: {
                return this.readInt();
            }
            case 4: {
                return this.readLong();
            }
            case 5: {
                return this.readFloat();
            }
            case 6: {
                return this.readDouble();
            }
            case 7: {
                return this.readByteArray();
            }
            case 8: {
                return this.readString();
            }
            case 9: {
                return this.readListTag();
            }
            case 10: {
                return this.readCompoundTag();
            }
            case 11: {
                return this.readIntArray();
            }
            case 12: {
                return this.readLongArray();
            }
        }
        throw new IllegalArgumentException("Unknown type " + id);
    }

    @NotNull
    public ByteTag readByte() throws IOException {
        return Tag.createByte(this.input.readByte());
    }

    @NotNull
    public ByteArrayTag readByteArray() throws IOException {
        int length = this.input.readInt();
        byte[] value = new byte[length];
        this.input.readFully(value);
        return Tag.createByteArray(value);
    }

    @NotNull
    public CompoundTag readCompoundTag() throws IOException {
        CompoundTag compoundTag = Tag.createCompound();
        while (true) {
            byte id;
            try {
                id = this.input.readByte();
            }
            catch (EOFException e) {
                break;
            }
            if (id == TagTypes.END.getId()) break;
            String key = this.input.readUTF();
            Tag tag = this.read(id);
            compoundTag.set(key, tag);
        }
        return compoundTag;
    }

    @NotNull
    public DoubleTag readDouble() throws IOException {
        return Tag.createDouble(this.input.readDouble());
    }

    @NotNull
    public FloatTag readFloat() throws IOException {
        return Tag.createFloat(this.input.readFloat());
    }

    @NotNull
    public IntTag readInt() throws IOException {
        return Tag.createInt(this.input.readInt());
    }

    @NotNull
    public IntArrayTag readIntArray() throws IOException {
        int length = this.input.readInt();
        int[] value = new int[length];
        for (int i = 0; i < length; ++i) {
            value[i] = this.input.readInt();
        }
        return Tag.createIntArray(value);
    }

    @NotNull
    public ListTag readListTag() throws IOException {
        byte id = this.input.readByte();
        int length = this.input.readInt();
        ArrayList<Tag> tags = new ArrayList<Tag>(length);
        for (int i = 0; i < length; ++i) {
            Tag read = this.read(id);
            tags.add(read);
        }
        return Tag.createList(tags);
    }

    @NotNull
    public LongTag readLong() throws IOException {
        return Tag.createLong(this.input.readLong());
    }

    @NotNull
    public LongArrayTag readLongArray() throws IOException {
        int length = this.input.readInt();
        long[] value = new long[length];
        for (int i = 0; i < length; ++i) {
            value[i] = this.input.readLong();
        }
        return Tag.createLongArray(value);
    }

    @NotNull
    public ShortTag readShort() throws IOException {
        return Tag.createShort(this.input.readShort());
    }

    @NotNull
    public StringTag readString() throws IOException {
        return Tag.createString(this.input.readUTF());
    }

    @NotNull
    public DataInput input() {
        return this.input;
    }

    public boolean closed() {
        return this.closed;
    }
}

