/*
 * Decompiled with CFR 0.152.
 */
package io.github.shiruka.nbt.stream;

import io.github.shiruka.nbt.CompoundTag;
import io.github.shiruka.nbt.ListTag;
import io.github.shiruka.nbt.Tag;
import io.github.shiruka.nbt.TagTypes;
import io.github.shiruka.nbt.array.ByteArrayTag;
import io.github.shiruka.nbt.array.IntArrayTag;
import io.github.shiruka.nbt.array.LongArrayTag;
import io.github.shiruka.nbt.primitive.ByteTag;
import io.github.shiruka.nbt.primitive.DoubleTag;
import io.github.shiruka.nbt.primitive.FloatTag;
import io.github.shiruka.nbt.primitive.IntTag;
import io.github.shiruka.nbt.primitive.LongTag;
import io.github.shiruka.nbt.primitive.ShortTag;
import io.github.shiruka.nbt.primitive.StringTag;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class NBTOutputStream
implements Closeable {
    @NotNull
    private final DataOutput output;
    private boolean closed = false;

    public NBTOutputStream(@NotNull DataOutput output) {
        this.output = output;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.output instanceof Closeable) {
            ((Closeable)((Object)this.output)).close();
        }
    }

    public void write(@NotNull Tag value) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Trying to read from a closed reader!");
        }
        if (value.isByte()) {
            this.writeByte(value.asByte());
        } else if (value.isShort()) {
            this.writeShort(value.asShort());
        } else if (value.isInt()) {
            this.writeInt(value.asInt());
        } else if (value.isLong()) {
            this.writeLong(value.asLong());
        } else if (value.isFloat()) {
            this.writeFloat(value.asFloat());
        } else if (value.isDouble()) {
            this.writeDouble(value.asDouble());
        } else if (value.isByteArray()) {
            this.writeByteArray(value.asByteArray());
        } else if (value.isString()) {
            this.writeString(value.asString());
        } else if (value.isList()) {
            this.writeListTag(value.asList());
        } else if (value.isCompound()) {
            this.writeCompoundTag(value.asCompound());
        } else if (value.isIntArray()) {
            this.writeIntArray(value.asIntArray());
        } else if (value.isLongArray()) {
            this.writeLongArray(value.asLongArray());
        } else {
            throw new IllegalArgumentException(String.format("Unknown type %s", new Object[]{value.getType()}));
        }
    }

    public void writeByte(@NotNull ByteTag value) throws IOException {
        this.output.writeByte(value.byteValue());
    }

    public void writeByteArray(@NotNull ByteArrayTag value) throws IOException {
        byte[] bytes = value.primitiveValue();
        this.output.writeInt(bytes.length);
        this.output.write(bytes);
    }

    public void writeCompoundTag(@NotNull CompoundTag value) throws IOException {
        Set<Map.Entry<String, Tag>> entries = value.all().entrySet();
        for (Map.Entry<String, Tag> entry : entries) {
            Tag tag = entry.getValue();
            this.output.writeByte(tag.getType().getId());
            if (tag.getType() == TagTypes.END) continue;
            this.output.writeUTF(entry.getKey());
            this.write(tag);
        }
        this.output.writeByte(TagTypes.END.getId());
    }

    public void writeDouble(@NotNull DoubleTag value) throws IOException {
        this.output.writeDouble(value.doubleValue());
    }

    public void writeFloat(@NotNull FloatTag value) throws IOException {
        this.output.writeFloat(value.floatValue());
    }

    public void writeInt(@NotNull IntTag value) throws IOException {
        this.output.writeInt(value.intValue());
    }

    public void writeIntArray(@NotNull IntArrayTag value) throws IOException {
        this.output.writeInt(value.size());
        Integer[] integerArray = value.value();
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int val = integerArray[i];
            this.output.writeInt(val);
        }
    }

    public void writeListTag(@NotNull ListTag value) throws IOException {
        this.output.writeByte(value.getListType().getId());
        this.output.writeInt(value.size());
        for (Tag tag : value) {
            this.write(tag);
        }
    }

    public void writeLong(@NotNull LongTag value) throws IOException {
        this.output.writeLong(value.longValue());
    }

    public void writeLongArray(@NotNull LongArrayTag value) throws IOException {
        this.output.writeInt(value.size());
        Long[] longArray = value.value();
        int n = longArray.length;
        for (int i = 0; i < n; ++i) {
            long val = longArray[i];
            this.output.writeLong(val);
        }
    }

    public void writeShort(@NotNull ShortTag value) throws IOException {
        this.output.writeShort(value.shortValue());
    }

    public void writeString(@NotNull StringTag value) throws IOException {
        this.output.writeUTF(value.value());
    }

    @NotNull
    public DataOutput output() {
        return this.output;
    }

    public boolean closed() {
        return this.closed;
    }
}

