/*
 * Decompiled with CFR 0.152.
 */
package io.github.shiruka.nbt.stream;

import io.github.shiruka.nbt.VarInts;
import io.github.shiruka.nbt.stream.LittleEndianDataInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;

public final class NetworkDataInputStream
extends LittleEndianDataInputStream {
    public NetworkDataInputStream(@NotNull InputStream stream) {
        super(stream);
    }

    public NetworkDataInputStream(@NotNull DataInputStream stream) {
        super(stream);
    }

    @Override
    public int readInt() throws IOException {
        return VarInts.readInt(this.stream);
    }

    @Override
    public long readLong() throws IOException {
        return VarInts.readLong(this.stream);
    }

    @Override
    @NotNull
    public String readUTF() throws IOException {
        int length = VarInts.readUnsignedInt(this.stream);
        byte[] bytes = new byte[length];
        this.readFully(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }
}

