/*
 * Decompiled with CFR 0.152.
 */
package top.shixinzhang.bitmapmonitor;

import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import android.util.Log;
import android.widget.Toast;
import androidx.annotation.Keep;
import com.bytedance.shadowhook.ShadowHook;
import java.util.LinkedList;
import java.util.List;
import top.shixinzhang.bitmapmonitor.BitmapMonitorData;
import top.shixinzhang.bitmapmonitor.ui.FloatWindow;

@Keep
public class BitmapMonitor {
    private static final String TAG = "BitmapMonitor";
    private static List<BitmapInfoListener> sListener;
    private static Config sConfig;
    private static CurrentSceneProvider sCurrentSceneProvider;

    public static boolean init(Config config) {
        if (config == null) {
            return false;
        }
        sConfig = config;
        int ret = ShadowHook.init();
        ShadowHook.setDebuggable((boolean)config.isDebug);
        BitmapMonitor.log("init called, ret:" + ret + config);
        return ret == 0;
    }

    public static boolean start() {
        return BitmapMonitor.start(null);
    }

    public static boolean start(CurrentSceneProvider provider) {
        if (sConfig == null) {
            return false;
        }
        sCurrentSceneProvider = provider;
        int ret = BitmapMonitor.hookBitmapNative(BitmapMonitor.sConfig.checkRecycleInterval, BitmapMonitor.sConfig.getStackThreshold, BitmapMonitor.sConfig.restoreImageThreshold, BitmapMonitor.sConfig.restoreImageDirectory);
        if (BitmapMonitor.sConfig.showFloatWindow) {
            BitmapMonitor.toggleFloatWindowVisibility(true);
        }
        return ret == 0;
    }

    public static void stop() {
        BitmapMonitor.stopHookBitmapNative();
        sCurrentSceneProvider = null;
    }

    public static void toggleFloatWindowVisibility(boolean show) {
        if (sConfig == null || BitmapMonitor.sConfig.context == null) {
            return;
        }
        if (show) {
            Context context = BitmapMonitor.sConfig.context;
            FloatWindow.show(context);
            if (Build.VERSION.SDK_INT >= 23 && !Settings.canDrawOverlays((Context)context)) {
                Toast.makeText((Context)context, (CharSequence)"\u9700\u8981\u7ed9\u60ac\u6d6e\u7a97\u6743\u9650\u624d\u80fd\u5b9e\u65f6\u67e5\u770b\u56fe\u7247\u5185\u5b58\u6570\u636e", (int)0).show();
            }
        } else {
            FloatWindow.hide(BitmapMonitor.sConfig.context);
        }
    }

    public static BitmapMonitorData dumpBitmapInfo() {
        return BitmapMonitor.dumpBitmapInfoNative();
    }

    public static BitmapMonitorData dumpBitmapCount() {
        return BitmapMonitor.dumpBitmapCountNative();
    }

    public static void addListener(BitmapInfoListener listener) {
        if (!sListener.contains(listener)) {
            sListener.add(listener);
        }
    }

    public static void removeListener(BitmapInfoListener listener) {
        sListener.remove(listener);
    }

    @Keep
    public static void reportBitmapInfo(BitmapMonitorData info) {
        for (BitmapInfoListener listener : sListener) {
            listener.onBitmapInfoChanged(info);
        }
    }

    @Keep
    public static String dumpJavaStack() {
        StackTraceElement[] st = Thread.currentThread().getStackTrace();
        StringBuilder sb = new StringBuilder();
        sb.setLength(0);
        sb.append(Thread.currentThread().getName()).append("\n");
        boolean beginBusinessCode = false;
        for (StackTraceElement s : st) {
            boolean isInternalLogic;
            String fileName = s.getFileName();
            String className = s.getClassName();
            boolean bl = isInternalLogic = className != null && className.contains("top.shixinzhang.bitmapmonitor.ui");
            if (isInternalLogic) {
                return null;
            }
            if (beginBusinessCode) {
                sb.append("\tat ").append(className).append(".").append(s.getMethodName()).append("(").append(fileName).append(":").append(s.getLineNumber()).append(")\n");
                continue;
            }
            beginBusinessCode = fileName != null && fileName.contains("BitmapMonitor.java");
        }
        BitmapMonitor.log("dumpJavaStack: " + Thread.currentThread().getName());
        BitmapMonitor.log("dumpJavaStack: " + sb.toString());
        return sb.toString();
    }

    @Keep
    public static String getCurrentScene() {
        if (sCurrentSceneProvider != null) {
            return sCurrentSceneProvider.getCurrentScene();
        }
        return null;
    }

    private static void log(String msg) {
        if (sConfig == null || !BitmapMonitor.sConfig.isDebug) {
            return;
        }
        Log.d((String)TAG, (String)msg);
    }

    public static Config getConfig() {
        return sConfig;
    }

    @Keep
    private static native int hookBitmapNative(long var0, long var2, long var4, String var6);

    @Keep
    private static native void stopHookBitmapNative();

    @Keep
    private static native BitmapMonitorData dumpBitmapCountNative();

    @Keep
    private static native BitmapMonitorData dumpBitmapInfoNative();

    static {
        System.loadLibrary("bitmapmonitor");
        sListener = new LinkedList<BitmapInfoListener>();
    }

    public static class Config {
        long checkRecycleInterval;
        long getStackThreshold;
        long restoreImageThreshold;
        String restoreImageDirectory;
        boolean showFloatWindow;
        boolean isDebug;
        boolean persistDataInDisk;
        Context context;

        private Config(Builder builder) {
            this.checkRecycleInterval = builder.checkRecycleInterval;
            this.getStackThreshold = builder.getStackThreshold;
            this.restoreImageThreshold = builder.restoreImageThreshold;
            this.restoreImageDirectory = builder.restoreImageDirectory;
            this.showFloatWindow = builder.showFloatWindow;
            this.isDebug = builder.isDebug;
            this.persistDataInDisk = builder.persistDataInDisk;
            this.context = builder.context;
        }

        public String toString() {
            return "Config:\ncheckRecycleInterval=" + this.checkRecycleInterval + ", \ngetStackThreshold=" + this.getStackThreshold + ", \nrestoreImageThreshold=" + this.restoreImageThreshold + ", \nrestoreImageDirectory='" + this.restoreImageDirectory + '\'' + ", \nshowFloatWindow=" + this.showFloatWindow + ", \nisDebug=" + this.isDebug;
        }

        public static final class Builder {
            private long checkRecycleInterval;
            private long getStackThreshold;
            private long restoreImageThreshold;
            private String restoreImageDirectory;
            private boolean showFloatWindow;
            private boolean isDebug;
            private boolean persistDataInDisk;
            private Context context;

            public Builder checkRecycleInterval(long val) {
                this.checkRecycleInterval = val;
                return this;
            }

            public Builder getStackThreshold(long val) {
                this.getStackThreshold = val;
                return this;
            }

            public Builder restoreImageThreshold(long val) {
                this.restoreImageThreshold = val;
                return this;
            }

            public Builder restoreImageDirectory(String val) {
                this.restoreImageDirectory = val;
                return this;
            }

            public Builder showFloatWindow(boolean val) {
                this.showFloatWindow = val;
                return this;
            }

            public Builder isDebug(boolean val) {
                this.isDebug = val;
                return this;
            }

            public Builder context(Context val) {
                this.context = val;
                return this;
            }

            public Config build() {
                return new Config(this);
            }
        }
    }

    public static interface CurrentSceneProvider {
        public String getCurrentScene();
    }

    public static interface BitmapInfoListener {
        public void onBitmapInfoChanged(BitmapMonitorData var1);
    }
}

