/*
 * Decompiled with CFR 0.152.
 */
package top.shixinzhang.bitmapmonitor;

import androidx.annotation.Keep;
import java.util.Arrays;
import java.util.Locale;
import top.shixinzhang.bitmapmonitor.BitmapRecord;

@Keep
public class BitmapMonitorData {
    public long createBitmapCount;
    public long createBitmapMemorySize;
    public long remainBitmapCount;
    public long remainBitmapMemorySize;
    public BitmapRecord[] remainBitmapRecords;

    public BitmapMonitorData(long createBitmapCount, long createBitmapMemorySize, long remainBitmapCount, long remainBitmapMemorySize) {
        this.createBitmapCount = createBitmapCount;
        this.createBitmapMemorySize = createBitmapMemorySize;
        this.remainBitmapCount = remainBitmapCount;
        this.remainBitmapMemorySize = remainBitmapMemorySize;
    }

    public String getCreateBitmapMemorySizeWithFormat() {
        return BitmapMonitorData.getFormatSize(this.createBitmapMemorySize);
    }

    public String getRemainBitmapMemorySizeWithFormat() {
        return BitmapMonitorData.getFormatSize(this.remainBitmapMemorySize);
    }

    public static String getFormatSize(long size) {
        float memory = (float)size * 1.0f;
        String unit = "b";
        if (memory > 1024.0f) {
            memory /= 1024.0f;
            unit = "Kb";
        }
        if (memory > 1024.0f) {
            memory /= 1024.0f;
            unit = "Mb";
        }
        if (memory > 1024.0f) {
            memory /= 1024.0f;
            unit = "Gb";
        }
        return String.format(Locale.getDefault(), "%.0f %s", Float.valueOf(memory), unit);
    }

    public String toString() {
        return "BitmapMonitorData{createBitmapCount=" + this.createBitmapCount + ", createBitmapMemorySize=" + this.createBitmapMemorySize + ", remainBitmapCount=" + this.remainBitmapCount + ", remainBitmapMemorySize=" + this.remainBitmapMemorySize + ", remainBitmapRecords=" + Arrays.toString(this.remainBitmapRecords) + '}';
    }

    public static enum AndroidBitmapFormat {
        ANDROID_BITMAP_FORMAT_NONE("None", 0),
        ANDROID_BITMAP_FORMAT_RGBA_8888("RGBA_8888", 1),
        ANDROID_BITMAP_FORMAT_RGB_565("RGB_565", 4),
        ANDROID_BITMAP_FORMAT_RGBA_4444("RGBA_4444", 7),
        ANDROID_BITMAP_FORMAT_A_8("ALPHA_8", 8),
        ANDROID_BITMAP_FORMAT_RGBA_F16("RGBA_F16", 9);

        String name;
        int code;

        private AndroidBitmapFormat(String name, int code) {
            this.name = name;
            this.code = code;
        }

        public static String getBitmapFormatName(int code) {
            switch (code) {
                case 1: {
                    return AndroidBitmapFormat.ANDROID_BITMAP_FORMAT_RGBA_8888.name;
                }
                case 4: {
                    return AndroidBitmapFormat.ANDROID_BITMAP_FORMAT_RGB_565.name;
                }
                case 7: {
                    return AndroidBitmapFormat.ANDROID_BITMAP_FORMAT_RGBA_4444.name;
                }
                case 8: {
                    return AndroidBitmapFormat.ANDROID_BITMAP_FORMAT_A_8.name;
                }
                case 9: {
                    return AndroidBitmapFormat.ANDROID_BITMAP_FORMAT_RGBA_F16.name;
                }
            }
            return AndroidBitmapFormat.ANDROID_BITMAP_FORMAT_NONE.name;
        }
    }
}

