/*
 * Decompiled with CFR 0.152.
 */
package top.shixinzhang.bitmapmonitor;

import androidx.annotation.Keep;
import java.io.Serializable;
import top.shixinzhang.bitmapmonitor.BitmapMonitorData;

@Keep
public class BitmapRecord
implements Serializable {
    public int width;
    public int height;
    public int bitsPerPixel;
    public int format;
    public long time;
    public long nativePtr;
    public String pictureExplorePath;
    public String createStack;
    public String currentScene;

    public BitmapRecord(long nativePtr, int width, int height, int bitsPerPixel, int format, long time, String pictureExplorePath, String createStack, String currentScene) {
        this.nativePtr = nativePtr;
        this.width = width;
        this.height = height;
        this.bitsPerPixel = bitsPerPixel;
        this.format = format;
        this.time = time;
        this.pictureExplorePath = pictureExplorePath;
        this.createStack = createStack;
        this.currentScene = currentScene;
    }

    public String toString() {
        return "BitmapRecord{nativePtr=" + this.nativePtr + ", width=" + this.width + ", height=" + this.height + ", bitsPerPixel=" + this.bitsPerPixel + ", format=" + this.format + ", pictureExplorePath='" + this.pictureExplorePath + '\'' + ", createStack='" + this.createStack + '\'' + ", currentScene='" + this.currentScene + '\'' + '}';
    }

    public String getFormatSize() {
        int size = this.width * this.height * this.bitsPerPixel;
        return BitmapMonitorData.getFormatSize(size);
    }
}

