/*
 * Decompiled with CFR 0.152.
 */
package top.shixinzhang.bitmapmonitor.ui;

import android.app.Activity;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.Keep;
import androidx.annotation.Nullable;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Locale;
import top.shixinzhang.bitmapmonitor.BitmapMonitor;
import top.shixinzhang.bitmapmonitor.BitmapRecord;
import top.shixinzhang.bitmapmonitor.R;
import top.shixinzhang.bitmapmonitor.ui.BitmapRecordsActivity;

@Keep
public class BitmapRecordDetailActivity
extends Activity {
    public static final String IMAGE_RESTORE_DEFAULT = "\u56fe\u7247\u5927\u5c0f\u6ca1\u6709\u8fbe\u5230\u9608\u503c\uff0c\u56e0\u6b64\u6ca1\u6709\u8fd8\u539f\u4e3a\u56fe\u7247";
    public static final String STACK_TRACE_DEFAULT = "\u56fe\u7247\u5927\u5c0f\u6ca1\u6709\u8fbe\u5230\u9608\u503c\uff0c\u56e0\u6b64\u6ca1\u6709\u83b7\u53d6\u5806\u6808";
    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_bitmap_record_detail);
        View recordSummaryView = this.findViewById(R.id.containr_bitmap_record);
        ImageView imageView = (ImageView)this.findViewById(R.id.iv_image);
        TextView stacktraceTextView = (TextView)this.findViewById(R.id.tv_stacktrace);
        TextView imageRestorePathTextView = (TextView)this.findViewById(R.id.tv_restore_path);
        Intent intent = this.getIntent();
        if (intent != null && intent.getSerializableExtra("data") != null) {
            BitmapRecord record = (BitmapRecord)intent.getSerializableExtra("data");
            BitmapRecordsActivity.BitmapRecordViewHolder holder = new BitmapRecordsActivity.BitmapRecordViewHolder(recordSummaryView);
            this.setData(holder, record);
            this.showImage(imageView, record);
            String stacktrace = TextUtils.isEmpty((CharSequence)record.createStack) ? this.getStackTraceDefaultTip() : record.createStack;
            BitmapRecordDetailActivity.setTextSafe(stacktraceTextView, stacktrace);
            String path = TextUtils.isEmpty((CharSequence)record.pictureExplorePath) ? IMAGE_RESTORE_DEFAULT : record.pictureExplorePath;
            BitmapRecordDetailActivity.setTextSafe(imageRestorePathTextView, path);
        }
    }

    private String getStackTraceDefaultTip() {
        return "\u56fe\u7247\u5927\u5c0f\u6ca1\u6709\u8fbe\u5230\u9608\u503c\uff0c\u56e0\u6b64\u6ca1\u6709\u83b7\u53d6\u5806\u6808\n" + BitmapMonitor.getConfig();
    }

    public static void setTextSafe(TextView textView, String data) {
        if (textView == null || TextUtils.isEmpty((CharSequence)data)) {
            return;
        }
        textView.setText((CharSequence)data);
        if (textView.getVisibility() != 0) {
            textView.setVisibility(0);
        }
    }

    private void setData(BitmapRecordsActivity.BitmapRecordViewHolder holder, BitmapRecord record) {
        String sizeInfo = String.format(Locale.getDefault(), "%s   %dx%dx%d", record.getFormatSize(), record.width, record.height, record.bitsPerPixel);
        BitmapRecordDetailActivity.setTextSafe(holder.sizeTextView, sizeInfo);
        BitmapRecordDetailActivity.setTextSafe(holder.timeTextView, this.dateFormat.format(record.time));
        BitmapRecordDetailActivity.setTextSafe(holder.sceneTextView, record.currentScene);
    }

    private void showImage(ImageView imageView, BitmapRecord record) {
        if (record == null || record.pictureExplorePath == null) {
            imageView.setVisibility(8);
            return;
        }
        if (new File(record.pictureExplorePath).exists()) {
            Bitmap bitmap = BitmapFactory.decodeFile((String)record.pictureExplorePath);
            imageView.setImageBitmap(bitmap);
        }
    }
}

