/*
 * Decompiled with CFR 0.152.
 */
package top.shixinzhang.bitmapmonitor.ui;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Locale;
import top.shixinzhang.bitmapmonitor.BitmapMonitor;
import top.shixinzhang.bitmapmonitor.BitmapMonitorData;
import top.shixinzhang.bitmapmonitor.BitmapRecord;
import top.shixinzhang.bitmapmonitor.R;
import top.shixinzhang.bitmapmonitor.ui.BitmapRecordDetailActivity;

@Keep
public class BitmapRecordsActivity
extends Activity {
    RecyclerView recyclerView;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_bitmap_records);
        TextView summaryTv = (TextView)this.findViewById(R.id.tv_summary);
        this.recyclerView = (RecyclerView)this.findViewById(R.id.recycler_view);
        BitmapMonitorData data = BitmapMonitor.dumpBitmapInfo();
        if (data == null) {
            return;
        }
        summaryTv.setText((CharSequence)String.format(Locale.getDefault(), "\u521b\u5efa\u4e86 %d \u5f20\u56fe\u7247\uff0c\u5360\u7528\u5185\u5b58 %s \uff1b\n\u5c1a\u672a\u56de\u6536\u7684\u56fe\u7247 %d \u5f20\uff0c\u5360\u7528\u5185\u5b58 %s\u3002", data.createBitmapCount, data.getCreateBitmapMemorySizeWithFormat(), data.remainBitmapCount, data.getRemainBitmapMemorySizeWithFormat()));
        BitmapRecord[] remainBitmapRecords = data.remainBitmapRecords;
        if (remainBitmapRecords != null && remainBitmapRecords.length > 0) {
            LinearLayoutManager linearLayoutManager = new LinearLayoutManager((Context)this, 1, false);
            this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)linearLayoutManager);
            BitmapRecordAdapter bitmapRecordAdapter = new BitmapRecordAdapter(remainBitmapRecords, (Context)this);
            this.recyclerView.setAdapter((RecyclerView.Adapter)bitmapRecordAdapter);
        }
    }

    static class BitmapRecordViewHolder
    extends RecyclerView.ViewHolder {
        public TextView indexTextView;
        public TextView sizeTextView;
        public TextView timeTextView;
        public TextView sceneTextView;

        public BitmapRecordViewHolder(@NonNull View itemView) {
            super(itemView);
            this.indexTextView = (TextView)itemView.findViewById(R.id.tv_index);
            this.sizeTextView = (TextView)itemView.findViewById(R.id.tv_size);
            this.timeTextView = (TextView)itemView.findViewById(R.id.tv_time);
            this.sceneTextView = (TextView)itemView.findViewById(R.id.tv_scene);
        }
    }

    static class BitmapRecordAdapter
    extends RecyclerView.Adapter<BitmapRecordViewHolder> {
        BitmapRecord[] data;
        Context context;
        LayoutInflater layoutInflater;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());

        public BitmapRecordAdapter(BitmapRecord[] data, Context context) {
            this.data = data;
            this.context = context;
            this.layoutInflater = LayoutInflater.from((Context)context);
        }

        @NonNull
        public BitmapRecordViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
            View view = this.layoutInflater.inflate(R.layout.item_bitmap_record, parent, false);
            return new BitmapRecordViewHolder(view);
        }

        public void onBindViewHolder(@NonNull BitmapRecordViewHolder holder, int position) {
            if (position >= this.data.length) {
                return;
            }
            BitmapRecordDetailActivity.setTextSafe(holder.indexTextView, String.valueOf(position + 1));
            final BitmapRecord record = this.data[position];
            String sizeInfo = String.format(Locale.getDefault(), "%s     %dx%d", record.getFormatSize(), record.width, record.height);
            BitmapRecordDetailActivity.setTextSafe(holder.sizeTextView, sizeInfo);
            BitmapRecordDetailActivity.setTextSafe(holder.timeTextView, this.dateFormat.format(record.time));
            BitmapRecordDetailActivity.setTextSafe(holder.sceneTextView, record.currentScene);
            holder.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (context != null) {
                        Intent intent = new Intent(context, BitmapRecordDetailActivity.class);
                        intent.addFlags(0x10000000);
                        intent.putExtra("data", (Serializable)record);
                        context.startActivity(intent);
                    }
                }
            });
        }

        public int getItemCount() {
            return this.data != null ? this.data.length : 0;
        }
    }
}

