/*
 * Decompiled with CFR 0.152.
 */
package top.shixinzhang.bitmapmonitor.ui;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.provider.Settings;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.TextView;
import androidx.annotation.Nullable;
import java.util.Locale;
import top.shixinzhang.bitmapmonitor.BitmapMonitor;
import top.shixinzhang.bitmapmonitor.BitmapMonitorData;
import top.shixinzhang.bitmapmonitor.R;
import top.shixinzhang.bitmapmonitor.ui.BitmapRecordsActivity;

public class FloatWindowService
extends Service
implements BitmapMonitor.BitmapInfoListener {
    private float lastMoveX;
    private float lastMoveY;
    private View floatView;
    private TextView bitmapCountTextView;
    private TextView memoryUsageTextView;
    private WindowManager windowManager;
    private WindowManager.LayoutParams layoutParams;
    private final Handler H = new Handler(Looper.getMainLooper());
    private final Runnable openActivityRunnable = new Runnable(){

        @Override
        public void run() {
            Intent intent = new Intent((Context)FloatWindowService.this, BitmapRecordsActivity.class);
            intent.addFlags(0x10000000);
            FloatWindowService.this.startActivity(intent);
        }
    };

    @Nullable
    public IBinder onBind(Intent intent) {
        return null;
    }

    public void onCreate() {
        super.onCreate();
        this.windowManager = (WindowManager)this.getSystemService("window");
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        if (Build.VERSION.SDK_INT >= 23 && Settings.canDrawOverlays((Context)this)) {
            this.addFloatView();
            BitmapMonitor.addListener(this);
        }
        return super.onStartCommand(intent, flags, startId);
    }

    private void addFloatView() {
        if (this.windowManager == null) {
            return;
        }
        this.floatView = LayoutInflater.from((Context)this).inflate(R.layout.layout_float_window, null);
        this.bitmapCountTextView = (TextView)this.floatView.findViewById(R.id.tv_bitmap_count);
        this.memoryUsageTextView = (TextView)this.floatView.findViewById(R.id.tv_bitmap_memory_usage);
        this.layoutParams = (WindowManager.LayoutParams)this.floatView.getLayoutParams();
        if (this.layoutParams == null) {
            int type = 2002;
            if (Build.VERSION.SDK_INT >= 26) {
                type = 2038;
            }
            int layoutParamFlags = 40;
            this.layoutParams = new WindowManager.LayoutParams(200, 200, 300, 50, type, layoutParamFlags, 1);
        }
        this.windowManager.addView(this.floatView, (ViewGroup.LayoutParams)this.layoutParams);
        this.setListener();
        BitmapMonitorData bitmapMonitorData = BitmapMonitor.dumpBitmapCount();
        this.updateFloatViewUI(bitmapMonitorData);
    }

    private void setListener() {
        if (this.floatView == null) {
            return;
        }
        this.floatView.findViewById(R.id.iv_close).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FloatWindowService.this.removeView();
            }
        });
        this.floatView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (event == null) {
                    return true;
                }
                int action = event.getAction();
                switch (action) {
                    case 0: {
                        FloatWindowService.this.lastMoveX = event.getRawX();
                        FloatWindowService.this.lastMoveY = event.getRawY();
                        FloatWindowService.this.H.removeCallbacks(FloatWindowService.this.openActivityRunnable);
                        FloatWindowService.this.H.postDelayed(FloatWindowService.this.openActivityRunnable, 300L);
                        break;
                    }
                    case 2: {
                        float currentMoveX = event.getRawX();
                        float currentMoveY = event.getRawY();
                        float offsetX = currentMoveX - FloatWindowService.this.lastMoveX;
                        float offsetY = currentMoveY - FloatWindowService.this.lastMoveY;
                        Log.d((String)"bitmap_monitor", (String)("ACTION_MOVE >>> " + offsetX + ", " + offsetY));
                        if (offsetX != 0.0f && offsetY != 0.0f) {
                            FloatWindowService.this.H.removeCallbacks(FloatWindowService.this.openActivityRunnable);
                        }
                        FloatWindowService.this.lastMoveX = currentMoveX;
                        FloatWindowService.this.lastMoveY = currentMoveY;
                        ((FloatWindowService)FloatWindowService.this).layoutParams.x = (int)((float)((FloatWindowService)FloatWindowService.this).layoutParams.x + offsetX);
                        ((FloatWindowService)FloatWindowService.this).layoutParams.y = (int)((float)((FloatWindowService)FloatWindowService.this).layoutParams.y + offsetY);
                        FloatWindowService.this.windowManager.updateViewLayout(FloatWindowService.this.floatView, (ViewGroup.LayoutParams)FloatWindowService.this.layoutParams);
                        break;
                    }
                    case 1: {
                        float currentMoveX1 = event.getRawX();
                        float currentMoveY1 = event.getRawY();
                        float offsetX1 = currentMoveX1 - FloatWindowService.this.lastMoveX;
                        float offsetY1 = currentMoveY1 - FloatWindowService.this.lastMoveY;
                        Log.d((String)"bitmap_monitor", (String)("ACTION_DOWN >>> " + offsetX1 + ", " + offsetY1));
                    }
                }
                return true;
            }
        });
    }

    public void onDestroy() {
        super.onDestroy();
        this.removeView();
        BitmapMonitor.removeListener(this);
    }

    private void removeView() {
        if (this.windowManager == null || this.floatView == null) {
            return;
        }
        this.windowManager.removeView(this.floatView);
        this.floatView = null;
    }

    @Override
    public void onBitmapInfoChanged(final BitmapMonitorData data) {
        this.H.post(new Runnable(){

            @Override
            public void run() {
                FloatWindowService.this.updateFloatViewUI(data);
            }
        });
    }

    private void updateFloatViewUI(BitmapMonitorData data) {
        if (data == null) {
            return;
        }
        Log.d((String)"BitmapMonitor", (String)("updateFloatViewUI: " + data));
        this.bitmapCountTextView.setText((CharSequence)String.format(Locale.getDefault(), "%d/%d", data.remainBitmapCount, data.createBitmapCount));
        String remainBitmapMemorySize = data.getRemainBitmapMemorySizeWithFormat();
        this.memoryUsageTextView.setText((CharSequence)remainBitmapMemorySize);
    }
}

