/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.actuator.endpoint;

import com.taotao.boot.actuator.endpoint.EndpointProperties;
import com.taotao.boot.actuator.endpoint.RequestMappingEndPoint;
import com.taotao.boot.actuator.endpoint.TtcEndPoint;
import com.taotao.boot.actuator.endpoint.TtcHealthEndPoint;
import com.taotao.boot.actuator.endpoint.health.TtcHealthIndicator;
import com.taotao.boot.actuator.endpoint.mbean.TtcMBean;
import com.taotao.boot.actuator.endpoint.mbean.TtcMbeanRegistrar;
import com.taotao.boot.common.utils.log.LogUtils;
import javax.management.MalformedObjectNameException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@EnableConfigurationProperties(value={EndpointProperties.class})
@ConditionalOnProperty(prefix="taotao.boot.actuator.endpoint", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class EndPointAutoConfiguration
implements InitializingBean {
    public void afterPropertiesSet() throws Exception {
        LogUtils.started(EndPointAutoConfiguration.class, (String)"taotao-boot-starter-core", (String[])new String[0]);
    }

    @Bean
    public TtcHealthIndicator ttcHealthIndicator() {
        return new TtcHealthIndicator();
    }

    @Bean
    public TtcHealthEndPoint ttcHealthEndPoint(TtcHealthIndicator ttcHealthIndicator) {
        return new TtcHealthEndPoint(ttcHealthIndicator);
    }

    @Bean
    public TtcEndPoint ttcEndPoint() {
        return new TtcEndPoint();
    }

    @Bean
    public RequestMappingEndPoint requestMappingEndPoint() {
        return new RequestMappingEndPoint();
    }

    @Bean
    public TtcMBean ttcMBean() {
        return new TtcMBean();
    }

    @Bean
    public TtcMbeanRegistrar ttcMbeanRegistrar() throws MalformedObjectNameException {
        return new TtcMbeanRegistrar();
    }
}

