/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.captcha.support.graphic.definition;

import com.taotao.boot.cache.redis.repository.RedisRepository;
import com.taotao.boot.captcha.support.core.definition.domain.Metadata;
import com.taotao.boot.captcha.support.graphic.definition.AbstractBaseGraphicRenderer;
import com.taotao.boot.common.constant.SymbolConstants;
import java.awt.image.BufferedImage;
import java.time.Duration;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractPngGraphicRenderer
extends AbstractBaseGraphicRenderer {
    public AbstractPngGraphicRenderer(RedisRepository redisRepository, String cacheName) {
        super(redisRepository, cacheName);
    }

    public AbstractPngGraphicRenderer(RedisRepository redisRepository, String cacheName, Duration expire) {
        super(redisRepository, cacheName, expire);
    }

    @Override
    public Metadata draw() {
        Object[] drawCharacters = this.getDrawCharacters();
        BufferedImage bufferedImage = this.createPngBufferedImage((String[])drawCharacters);
        String characters = StringUtils.join((Object[])drawCharacters, (String)SymbolConstants.BLANK);
        Metadata metadata = new Metadata();
        metadata.setGraphicImageBase64(this.toBase64(bufferedImage));
        metadata.setCharacters(characters);
        return metadata;
    }
}

