/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.common.http;

import com.taotao.boot.common.http.AsyncCallback;
import com.taotao.boot.common.http.HttpException;
import com.taotao.boot.common.http.HttpResponse;
import com.taotao.boot.common.http.ResponseSpec;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Request;

public class AsyncExchange {
    private final Call call;
    @Nullable
    private Consumer<ResponseSpec> successConsumer;
    @Nullable
    private Consumer<ResponseSpec> responseConsumer;
    @Nullable
    private BiConsumer<Request, HttpException> failedBiConsumer;

    AsyncExchange(Call call) {
        this.call = call;
        this.successConsumer = null;
        this.responseConsumer = null;
        this.failedBiConsumer = null;
    }

    public void onSuccessful(Consumer<ResponseSpec> consumer) {
        this.successConsumer = consumer;
        this.execute();
    }

    public void onResponse(Consumer<ResponseSpec> consumer) {
        this.responseConsumer = consumer;
        this.execute();
    }

    public AsyncExchange onFailed(BiConsumer<Request, HttpException> biConsumer) {
        this.failedBiConsumer = biConsumer;
        return this;
    }

    private void execute() {
        this.call.enqueue((Callback)new AsyncCallback(this));
    }

    protected void onResponse(HttpResponse response) {
        if (this.responseConsumer != null) {
            this.responseConsumer.accept(response);
        }
    }

    protected void onSuccessful(HttpResponse response) {
        if (this.successConsumer != null) {
            this.successConsumer.accept(response);
        }
    }

    protected void onFailure(Request request, IOException e) {
        if (this.failedBiConsumer != null) {
            this.failedBiConsumer.accept(request, new HttpException(request, (Throwable)e));
        }
    }

    protected void onFailure(HttpResponse response) {
        if (this.failedBiConsumer != null) {
            this.failedBiConsumer.accept(response.rawRequest(), new HttpException(response));
        }
    }
}

