/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.common.http;

import com.taotao.boot.common.http.AsyncExchange;
import com.taotao.boot.common.http.Exchange;
import com.taotao.boot.common.http.HttpRequest;
import com.taotao.boot.common.utils.exception.ExceptionUtils;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okio.Buffer;

public class MultipartFormBuilder {
    private final HttpRequest request;
    private final MultipartBody.Builder formBuilder;

    MultipartFormBuilder(HttpRequest request) {
        this.request = request;
        this.formBuilder = new MultipartBody.Builder();
    }

    public MultipartFormBuilder add(String name, @Nullable Object value) {
        this.formBuilder.addFormDataPart(name, HttpRequest.handleValue(value));
        return this;
    }

    public MultipartFormBuilder addMap(@Nullable Map<String, Object> formMap) {
        if (formMap != null && !formMap.isEmpty()) {
            formMap.forEach(this::add);
        }
        return this;
    }

    public MultipartFormBuilder add(String name, File file) {
        String fileName = file.getName();
        return this.add(name, fileName, file);
    }

    public MultipartFormBuilder add(String name, @Nullable String filename, File file) {
        RequestBody fileBody = RequestBody.create((File)file, null);
        return this.add(name, filename, fileBody);
    }

    public MultipartFormBuilder add(String name, @Nonnull String filename, byte[] bytes) {
        RequestBody fileBody = RequestBody.create((byte[])bytes, null);
        return this.add(name, filename, fileBody);
    }

    public MultipartFormBuilder add(String name, @Nonnull String filename, InputStream stream) {
        try {
            MultipartFormBuilder multipartFormBuilder;
            Buffer buffer = new Buffer();
            try {
                buffer.readFrom(stream);
                multipartFormBuilder = this.add(name, filename, buffer.readByteArray());
            }
            catch (Throwable throwable) {
                try {
                    try {
                        buffer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw ExceptionUtils.unchecked(e);
                }
            }
            buffer.close();
            return multipartFormBuilder;
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public MultipartFormBuilder add(String name, @Nullable String filename, RequestBody fileBody) {
        this.formBuilder.addFormDataPart(name, filename, fileBody);
        return this;
    }

    public MultipartFormBuilder add(RequestBody body) {
        this.formBuilder.addPart(body);
        return this;
    }

    public MultipartFormBuilder add(@Nullable Headers headers, RequestBody body) {
        this.formBuilder.addPart(headers, body);
        return this;
    }

    public MultipartFormBuilder add(MultipartBody.Part part) {
        this.formBuilder.addPart(part);
        return this;
    }

    public HttpRequest build() {
        this.formBuilder.setType(MultipartBody.FORM);
        MultipartBody formBody = this.formBuilder.build();
        this.request.multipartForm(formBody);
        return this.request;
    }

    public Exchange execute() {
        return this.build().execute();
    }

    public AsyncExchange async() {
        return this.build().async();
    }
}

